/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2008 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_AAC_H__
#define __OGMRIP_AAC_H__

#include <ogmrip-audio-codec.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_AAC          (ogmrip_aac_get_type ())
#define OGMRIP_AAC(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_AAC, OGMRipAac))
#define OGMRIP_AAC_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_AAC, OGMRipAacClass))
#define OGMRIP_IS_AAC(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_AAC))
#define OGMRIP_IS_AAC_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_AAC))

typedef struct _OGMRipAac      OGMRipAac;
typedef struct _OGMRipAacClass OGMRipAacClass;

struct _OGMRipAac
{
  OGMRipAudioCodec parent_instance;
};

struct _OGMRipAacClass
{
  OGMRipAudioCodecClass parent_class;
};

GType         ogmrip_aac_get_type  (void);
OGMJobSpawn * ogmrip_aac_new       (OGMDvdAudioStream *audio,
                                    const gchar       *output);

G_END_DECLS

#endif /* __OGMRIP_AAC_H__ */

