/* OGMRip - A DVD Encoder for GNOME
 * Copyright (C) 2004-2009 Olivier Rolland <billl@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __OGMRIP_PREFERENCES_H__
#define __OGMRIP_PREFERENCES_H__

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>

G_BEGIN_DECLS

typedef GConfValue * (* OGMRipPrefGetFunc) (GtkWidget  *widget);
typedef gboolean     (* OGMRipPrefSetFunc) (GtkWidget  *widget,
                                            GConfValue *value);

void         ogmrip_preferences_init                   (const gchar            *dir);
void         ogmrip_preferences_uninit                 (void);

void         ogmrip_preferences_set_default_dir        (const gchar            *dir);

GConfValue * ogmrip_preferences_get                    (const gchar            *key);
void         ogmrip_preferences_set                    (const gchar            *key,
                                                        GConfValue             *value);

gboolean     ogmrip_preferences_get_bool               (const gchar            *key,
                                                        gboolean               def);
void         ogmrip_preferences_set_bool               (const gchar            *key,
                                                        gboolean               value);

gint         ogmrip_preferences_get_int                (const gchar            *key,
                                                        gint                   def);
void         ogmrip_preferences_set_int                (const gchar            *key,
                                                        gint                   value);

gdouble      ogmrip_preferences_get_double             (const gchar            *key,
                                                        gdouble                def);
void         ogmrip_preferences_set_double             (const gchar            *key,
                                                        gdouble                value);

gchar *      ogmrip_preferences_get_string             (const gchar            *key,
                                                        const gchar            *def);
void         ogmrip_preferences_set_string             (const gchar            *key,
                                                        const gchar            *value);

gchar *      ogmrip_preferences_get_filename           (const gchar            *key,
                                                        const gchar            *def);
void         ogmrip_preferences_set_filename           (const gchar            *key,
                                                        const gchar            *value);

void         ogmrip_preferences_unset                  (const gchar            *key);
void         ogmrip_preferences_recursive_unset        (const gchar            *key);

gboolean     ogmrip_preferences_dir_exists             (const gchar            *dir);
GSList *     ogmrip_preferences_all_dirs               (const gchar            *dir);
GSList *     ogmrip_preferences_all_entries            (const gchar            *dir);

guint        ogmrip_preferences_add_notify             (const gchar            *key,
                                                        GFunc                  func,
                                                        gpointer               data);
guint        ogmrip_preferences_add_notify_while_alive (const gchar            *key,
                                                        GFunc                  func,
                                                        gpointer               data,
                                                        gpointer               widget);

void         ogmrip_preferences_connect_toggle         (GtkWidget              *toggle,
                                                        const gchar            *key);
void         ogmrip_preferences_connect_toggle_custom  (GtkWidget              *toggle,
                                                        const gchar            *key,
                                                        OGMRipPrefGetFunc      get_func,
                                                        OGMRipPrefSetFunc      set_func);

void         ogmrip_preferences_connect_combo          (GtkWidget              *combo,
                                                        const gchar            *key);
void         ogmrip_preferences_connect_combo_custom   (GtkWidget              *combo,
                                                        const gchar            *key,
                                                        OGMRipPrefGetFunc      get_func,
                                                        OGMRipPrefSetFunc      set_func);

void         ogmrip_preferences_connect_chooser        (GtkWidget              *chooser,
                                                        const gchar            *key);
void         ogmrip_preferences_connect_chooser_custom (GtkWidget              *chooser,
                                                        const gchar            *key,
                                                        OGMRipPrefGetFunc      get_func,
                                                        OGMRipPrefSetFunc      set_func);

void         ogmrip_preferences_connect_spin           (GtkWidget              *spin,
                                                        const gchar            *key);
void         ogmrip_preferences_connect_spin_custom    (GtkWidget              *spin, 
                                                        const gchar            *key,
                                                        OGMRipPrefGetFunc      get_func,
                                                        OGMRipPrefSetFunc      set_func);

void         ogmrip_preferences_connect_radio          (GtkWidget              *radio,
                                                        const gchar            *key);
void         ogmrip_preferences_connect_radio_custom   (GtkWidget              *radio, 
                                                        const gchar            *key,
                                                        OGMRipPrefGetFunc      get_func,
                                                        OGMRipPrefSetFunc      set_func);

G_END_DECLS

#endif /* __OGMRIP_PREFERENCES_H__ */

