// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AIS2D_ProjShape_HeaderFile
#define _AIS2D_ProjShape_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_AIS2D_ProjShape_HeaderFile
#include <Handle_AIS2D_ProjShape.hxx>
#endif

#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _HLRAlgo_Projector_HeaderFile
#include <HLRAlgo_Projector.hxx>
#endif
#ifndef _Handle_HLRBRep_Algo_HeaderFile
#include <Handle_HLRBRep_Algo.hxx>
#endif
#ifndef _Handle_HLRBRep_PolyAlgo_HeaderFile
#include <Handle_HLRBRep_PolyAlgo.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Graphic2d_SetOfSegments_HeaderFile
#include <Handle_Graphic2d_SetOfSegments.hxx>
#endif
#ifndef _Handle_GGraphic2d_SetOfCurves_HeaderFile
#include <Handle_GGraphic2d_SetOfCurves.hxx>
#endif
#ifndef _AIS2D_InteractiveObject_HeaderFile
#include <AIS2D_InteractiveObject.hxx>
#endif
#ifndef _Handle_Graphic2d_Line_HeaderFile
#include <Handle_Graphic2d_Line.hxx>
#endif
class HLRBRep_Algo;
class HLRBRep_PolyAlgo;
class Graphic2d_SetOfSegments;
class GGraphic2d_SetOfCurves;
class HLRAlgo_Projector;
class TopoDS_Shape;
class Graphic2d_Line;


//! Constructs presentable and selectable projection of <br>
//!          TopoDS_Shape on the view plane <br>
class AIS2D_ProjShape : public AIS2D_InteractiveObject {

public:
 // Methods PUBLIC
 // 

//! Initializes the projected shape <br>
Standard_EXPORT AIS2D_ProjShape();

//! Initializes the projected shape with projector <aProjector>, number isolines <nbIsos> <br>
Standard_EXPORT AIS2D_ProjShape(const HLRAlgo_Projector& aProjector,const Standard_Integer nbIsos = 3,const Standard_Boolean isPolyAlgo = Standard_False,const Standard_Boolean visHL = Standard_True);

//! Adds <aShape> to the list of projected shapes. <br>
Standard_EXPORT   void Add(const TopoDS_Shape& aShape) ;

//! sets the projector <aProjector> <br>
Standard_EXPORT   void SetProjector(const HLRAlgo_Projector& aProjector) ;

//! Indicates the projector <br>
Standard_EXPORT   HLRAlgo_Projector Projector() const;


Standard_EXPORT   void SetNbIsos(const Standard_Integer aNbIsos) ;

//! sets the projection of the shape as a polyhedral <br>
//!          simplification of the shape if <aIsPoly> is True <br>
Standard_EXPORT   void SetPolyAlgo(const Standard_Boolean aIsPoly = Standard_False) ;

//! Sets the hidden line mode if <aIsHLM> is True <br>
Standard_EXPORT   void SetHLMode(const Standard_Boolean aIsHLM = Standard_True) ;

//! Indicates the hidden lines are visible <br>
Standard_EXPORT   Standard_Boolean IsHLMode() const;

//! Indicates the number of isolines <br>
Standard_EXPORT   Standard_Integer GetNbIsos() const;

//! Indicates the shape was extracted as Algo or PolyAlgo <br>
Standard_EXPORT   Standard_Boolean GetIsPoly() const;

//! Returns the set of primitives are included into Shape, <br>
//!          except hidden lines <br>
Standard_EXPORT   Handle_Graphic2d_Line GetPrimitives() const;

//! Returns the set of hidden line primitives are included into Shape <br>
Standard_EXPORT   Handle_Graphic2d_Line GetHLPrimitives() const;

//! Sets the flags for display of all types of edges <br>
Standard_EXPORT   void ShowEdges(const Standard_Boolean aSharp = Standard_True,const Standard_Boolean aSmooth = Standard_True,const Standard_Boolean aSewn = Standard_True,const Standard_Boolean anOutline = Standard_True,const Standard_Boolean anIsoline = Standard_True) ;
//Standard_EXPORT ~AIS2D_ProjShape();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void CreateAlgo() ;


Standard_EXPORT   void CreatePolyAlgo() ;


Standard_EXPORT   void DrawSegments(const TopoDS_Shape& aShape,Handle(Graphic2d_SetOfSegments)& aSofS) ;


Standard_EXPORT   void DrawCurves(const TopoDS_Shape& aShape,Handle(GGraphic2d_SetOfCurves)& aSofC) ;


Standard_EXPORT   void ComputeShape() ;


 // Fields PRIVATE
 //
TopTools_ListOfShape myListOfShape;
HLRAlgo_Projector myProjector;
Handle_HLRBRep_Algo myAlgo;
Handle_HLRBRep_PolyAlgo myPolyAlgo;
Standard_Integer myNbIsos;
Standard_Boolean myIsPolyAlgo;
Standard_Boolean myIsHiddenLine;
Standard_Boolean myESharp;
Standard_Boolean myESmooth;
Standard_Boolean myESewn;
Standard_Boolean myEOutline;
Standard_Boolean myEIsoline;
Handle_Graphic2d_SetOfSegments mySetOfSegments;
Handle_Graphic2d_SetOfSegments myHSetOfSegments;
Handle_GGraphic2d_SetOfCurves mySetOfCurves;
Handle_GGraphic2d_SetOfCurves myHSetOfCurves;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
