// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Approx_SweepFunction_HeaderFile
#define _Approx_SweepFunction_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Approx_SweepFunction_HeaderFile
#include <Handle_Approx_SweepFunction.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class Standard_NotImplemented;
class Standard_OutOfRange;
class TColgp_Array1OfPnt;
class TColgp_Array1OfPnt2d;
class TColStd_Array1OfReal;
class TColgp_Array1OfVec;
class TColgp_Array1OfVec2d;
class TColStd_Array1OfInteger;
class gp_Pnt;


//! defined the function used by SweepApproximation to <br>
//!          perform sweeping application. <br>
class Approx_SweepFunction : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! compute the section for v = param <br>
Standard_EXPORT virtual  Standard_Boolean D0(const Standard_Real Param,const Standard_Real First,const Standard_Real Last,TColgp_Array1OfPnt& Poles,TColgp_Array1OfPnt2d& Poles2d,TColStd_Array1OfReal& Weigths)  = 0;

//! compute the first  derivative in v direction  of the <br>
//!           section for v =  param <br>
//!  Warning : It used only for C1 or C2 aproximation <br>
Standard_EXPORT virtual  Standard_Boolean D1(const Standard_Real Param,const Standard_Real First,const Standard_Real Last,TColgp_Array1OfPnt& Poles,TColgp_Array1OfVec& DPoles,TColgp_Array1OfPnt2d& Poles2d,TColgp_Array1OfVec2d& DPoles2d,TColStd_Array1OfReal& Weigths,TColStd_Array1OfReal& DWeigths) ;

//! compute the second derivative  in v direction of the <br>
//!          section  for v = param <br>
//!  Warning : It used only for C2 aproximation <br>
Standard_EXPORT virtual  Standard_Boolean D2(const Standard_Real Param,const Standard_Real First,const Standard_Real Last,TColgp_Array1OfPnt& Poles,TColgp_Array1OfVec& DPoles,TColgp_Array1OfVec& D2Poles,TColgp_Array1OfPnt2d& Poles2d,TColgp_Array1OfVec2d& DPoles2d,TColgp_Array1OfVec2d& D2Poles2d,TColStd_Array1OfReal& Weigths,TColStd_Array1OfReal& DWeigths,TColStd_Array1OfReal& D2Weigths) ;

//! get the number of 2d curves to  approximate. <br>
Standard_EXPORT virtual  Standard_Integer Nb2dCurves() const = 0;

//! get the format of an  section <br>
Standard_EXPORT virtual  void SectionShape(Standard_Integer& NbPoles,Standard_Integer& NbKnots,Standard_Integer& Degree) const = 0;

//! get the Knots of the section <br>
Standard_EXPORT virtual  void Knots(TColStd_Array1OfReal& TKnots) const = 0;

//! get the Multplicities of the section <br>
Standard_EXPORT virtual  void Mults(TColStd_Array1OfInteger& TMults) const = 0;

//! Returns if the sections are rationnal or not <br>
Standard_EXPORT virtual  Standard_Boolean IsRational() const = 0;

//! Returns  the number  of  intervals for  continuity <br>
//!          <S>. <br>
//!          May be one if Continuity(me) >= <S> <br>
Standard_EXPORT virtual  Standard_Integer NbIntervals(const GeomAbs_Shape S) const = 0;

//! Stores in <T> the  parameters bounding the intervals <br>
//!          of continuity <S>. <br>
//! <br>
//!          The array must provide  enough room to  accomodate <br>
//!          for the parameters. i.e. T.Length() > NbIntervals() <br>
Standard_EXPORT virtual  void Intervals(TColStd_Array1OfReal& T,const GeomAbs_Shape S) const = 0;

//! Sets the bounds of the parametric interval on <br>
//!          the fonction <br>
//!          This determines the derivatives in these values if the <br>
//!          function is not Cn. <br>
Standard_EXPORT virtual  void SetInterval(const Standard_Real First,const Standard_Real Last)  = 0;

//! Returns the resolutions in the  sub-space 2d <Index> <br>
//!          This information is usfull to find an good tolerance in <br>
//!          2d approximation. <br>
Standard_EXPORT virtual  void Resolution(const Standard_Integer Index,const Standard_Real Tol,Standard_Real& TolU,Standard_Real& TolV) const;

//! Returns the tolerance to reach in approximation <br>
//!          to satisfy. <br>
//!          BoundTol error at the Boundary <br>
//!          AngleTol tangent error at the Boundary (in radian) <br>
//!          SurfTol error inside the surface. <br>
Standard_EXPORT virtual  void GetTolerance(const Standard_Real BoundTol,const Standard_Real SurfTol,const Standard_Real AngleTol,TColStd_Array1OfReal& Tol3d) const = 0;

//! Is usefull, if (me) have to run numerical <br>
//!           algorithm to perform D0, D1 or D2 <br>
Standard_EXPORT virtual  void SetTolerance(const Standard_Real Tol3d,const Standard_Real Tol2d)  = 0;

//!  Get the barycentre of Surface. <br>
//!          An   very  poor estimation is sufficent. <br>
//!          This information is usefull to perform well <br>
//!          conditioned rational approximation. <br>
//!  Warning: Used only if <me> IsRational <br>
Standard_EXPORT virtual  gp_Pnt BarycentreOfSurf() const;

//! Returns the   length of the greater section. This <br>
//!          information is usefull to G1's control. <br>
//!  Warning: With an little value, approximation can be slower. <br>
Standard_EXPORT virtual  Standard_Real MaximalSection() const;

//! Compute the minimal value of weight for each poles <br>
//!          in all  sections. <br>
//!          This information is  usefull to control error <br>
//!          in rational approximation. <br>
//!  Warning: Used only if <me> IsRational <br>
Standard_EXPORT virtual  void GetMinimalWeight(TColStd_Array1OfReal& Weigths) const;
//Standard_EXPORT ~Approx_SweepFunction();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
