// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBlend_RstRstLineBuilder_HeaderFile
#define _BRepBlend_RstRstLineBuilder_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_BRepBlend_Line_HeaderFile
#include <Handle_BRepBlend_Line.hxx>
#endif
#ifndef _math_Vector_HeaderFile
#include <math_Vector.hxx>
#endif
#ifndef _Handle_Adaptor3d_HSurface_HeaderFile
#include <Handle_Adaptor3d_HSurface.hxx>
#endif
#ifndef _Handle_Adaptor3d_TopolTool_HeaderFile
#include <Handle_Adaptor3d_TopolTool.hxx>
#endif
#ifndef _Handle_Adaptor2d_HCurve2d_HeaderFile
#include <Handle_Adaptor2d_HCurve2d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Blend_Point_HeaderFile
#include <Blend_Point.hxx>
#endif
#ifndef _Blend_DecrochStatus_HeaderFile
#include <Blend_DecrochStatus.hxx>
#endif
#ifndef _Handle_Adaptor3d_HVertex_HeaderFile
#include <Handle_Adaptor3d_HVertex.hxx>
#endif
#ifndef _Blend_Status_HeaderFile
#include <Blend_Status.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
class BRepBlend_Line;
class Adaptor3d_HSurface;
class Adaptor3d_TopolTool;
class Adaptor2d_HCurve2d;
class Blend_RstRstFunction;
class Blend_SurfCurvFuncInv;
class Blend_CurvPointFuncInv;
class math_Vector;
class Adaptor3d_HVertex;
class IntSurf_Transition;
class BRepBlend_Extremity;
class Blend_Point;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  class processes the  data  resulting from <br>
//!          Blend_CSWalking  but  it  takes  in  consideration the Surface <br>
//!          supporting  the  curve to detect the  breakpoint. <br>
//! <br>
//!          As  a  result, the  criteria of distribution of <br>
//!          points on  the line become  more flexible  because  it <br>
//!          should  calculate values  approached <br>
//!          by an approximation of continued  functions based on the <br>
//!          Blend_RstRstFunction. <br>
//! <br>
//!          Thus this pseudo path necessitates 3 criteria  of <br>
//!          regrouping : <br>
//! <br>
//!          1) exit of  the domain of  the  curve <br>
//! <br>
//!          2) exit of  the domain of  the surface <br>
//! <br>
//!          3) stall as there  is a solution of problem <br>
//!          surf/surf  within the domain  of the  surface <br>
//!          of support of the restriction. <br>
class BRepBlend_RstRstLineBuilder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepBlend_RstRstLineBuilder(const Handle(Adaptor3d_HSurface)& Surf1,const Handle(Adaptor2d_HCurve2d)& Rst1,const Handle(Adaptor3d_TopolTool)& Domain1,const Handle(Adaptor3d_HSurface)& Surf2,const Handle(Adaptor2d_HCurve2d)& Rst2,const Handle(Adaptor3d_TopolTool)& Domain2);


Standard_EXPORT   void Perform(Blend_RstRstFunction& Func,Blend_SurfCurvFuncInv& Finv1,Blend_CurvPointFuncInv& FinvP1,Blend_SurfCurvFuncInv& Finv2,Blend_CurvPointFuncInv& FinvP2,const Standard_Real Pdep,const Standard_Real Pmax,const Standard_Real MaxStep,const Standard_Real TolGuide,const math_Vector& Soldep,const Standard_Real Tolesp,const Standard_Real Fleche,const Standard_Boolean Appro = Standard_False) ;


Standard_EXPORT   Standard_Boolean PerformFirstSection(Blend_RstRstFunction& Func,Blend_SurfCurvFuncInv& Finv1,Blend_CurvPointFuncInv& FinvP1,Blend_SurfCurvFuncInv& Finv2,Blend_CurvPointFuncInv& FinvP2,const Standard_Real Pdep,const Standard_Real Pmax,const math_Vector& Soldep,const Standard_Real Tolesp,const Standard_Real TolGuide,const Standard_Boolean RecRst1,const Standard_Boolean RecP1,const Standard_Boolean RecRst2,const Standard_Boolean RecP2,Standard_Real& Psol,math_Vector& ParSol) ;


Standard_EXPORT   Standard_Boolean Complete(Blend_RstRstFunction& Func,Blend_SurfCurvFuncInv& Finv1,Blend_CurvPointFuncInv& FinvP1,Blend_SurfCurvFuncInv& Finv2,Blend_CurvPointFuncInv& FinvP2,const Standard_Real Pmin) ;

  Standard_Boolean IsDone() const;

 const Handle_BRepBlend_Line& Line() const;

  Standard_Boolean Decroch1Start() const;

  Standard_Boolean Decroch1End() const;

  Standard_Boolean Decroch2Start() const;

  Standard_Boolean Decroch2End() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void InternalPerform(Blend_RstRstFunction& Func,Blend_SurfCurvFuncInv& Finv1,Blend_CurvPointFuncInv& FinvP1,Blend_SurfCurvFuncInv& Finv2,Blend_CurvPointFuncInv& FinvP2,const Standard_Real Bound) ;


Standard_EXPORT   Standard_Boolean Recadre1(Blend_RstRstFunction& Func,Blend_SurfCurvFuncInv& Finv,math_Vector& Solinv,Standard_Boolean& IsVtx,Handle(Adaptor3d_HVertex)& Vtx) ;


Standard_EXPORT   Standard_Boolean Recadre2(Blend_RstRstFunction& Func,Blend_SurfCurvFuncInv& Finv,math_Vector& Solinv,Standard_Boolean& IsVtx,Handle(Adaptor3d_HVertex)& Vtx) ;


Standard_EXPORT   Standard_Boolean Recadre1(Blend_CurvPointFuncInv& FinvP,math_Vector& Solinv,Standard_Boolean& IsVtx,Handle(Adaptor3d_HVertex)& Vtx) ;


Standard_EXPORT   Standard_Boolean Recadre2(Blend_CurvPointFuncInv& FinvP,math_Vector& Solinv,Standard_Boolean& IsVtx,Handle(Adaptor3d_HVertex)& Vtx) ;


Standard_EXPORT   void Transition(const Standard_Boolean OnFirst,const Handle(Adaptor2d_HCurve2d)& Arc,const Standard_Real Param,IntSurf_Transition& TLine,IntSurf_Transition& TArc) ;


Standard_EXPORT   void MakeExtremity(BRepBlend_Extremity& Extrem,const Standard_Boolean OnFirst,const Handle(Adaptor2d_HCurve2d)& Arc,const Standard_Real Param,const Standard_Boolean IsVtx,const Handle(Adaptor3d_HVertex)& Vtx) ;


Standard_EXPORT   Blend_Status CheckDeflectionOnRst1(const Blend_Point& CurPoint) ;


Standard_EXPORT   Blend_Status CheckDeflectionOnRst2(const Blend_Point& CurPoint) ;


Standard_EXPORT   Blend_Status TestArret(Blend_RstRstFunction& Func,const Standard_Boolean TestDeflection,const Blend_Status State) ;


Standard_EXPORT   Standard_Boolean CheckInside(Blend_RstRstFunction& Func,TopAbs_State& SituOnC1,TopAbs_State& SituOnC2,Blend_DecrochStatus& Decroch) ;


 // Fields PRIVATE
 //
Standard_Boolean done;
Handle_BRepBlend_Line line;
math_Vector sol;
Handle_Adaptor3d_HSurface surf1;
Handle_Adaptor3d_TopolTool domain1;
Handle_Adaptor3d_HSurface surf2;
Handle_Adaptor3d_TopolTool domain2;
Handle_Adaptor2d_HCurve2d rst1;
Handle_Adaptor2d_HCurve2d rst2;
Standard_Real tolesp;
Standard_Real tolgui;
Standard_Real pasmax;
Standard_Real fleche;
Standard_Real param;
Blend_Point previousP;
Standard_Boolean rebrou;
Standard_Boolean iscomplete;
Standard_Boolean comptra;
Standard_Real sens;
Blend_DecrochStatus decrochdeb;
Blend_DecrochStatus decrochfin;


};


#include <BRepBlend_RstRstLineBuilder.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
