// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _CPnts_MyRootFunction_HeaderFile
#define _CPnts_MyRootFunction_HeaderFile

#ifndef _CPnts_MyGaussFunction_HeaderFile
#include <CPnts_MyGaussFunction.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _math_FunctionWithDerivative_HeaderFile
#include <math_FunctionWithDerivative.hxx>
#endif
#ifndef _CPnts_RealFunction_HeaderFile
#include <CPnts_RealFunction.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Implements a function for the Newton algorithm to find the <br>
//!          solution of Integral(F) = L <br>
class CPnts_MyRootFunction  : public math_FunctionWithDerivative {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

CPnts_MyRootFunction();

//! F  is a pointer on a  function  D is a client data <br>
//!          Order is the order of integration to use <br>
//! <br>
Standard_EXPORT   void Init(const CPnts_RealFunction& F,const Standard_Address D,const Standard_Integer Order) ;

//! We want to solve Integral(X0,X,F(X,D)) = L <br>
Standard_EXPORT   void Init(const Standard_Real X0,const Standard_Real L) ;

//! We want to solve Integral(X0,X,F(X,D)) = L <br>
//!  with given tolerance <br>
Standard_EXPORT   void Init(const Standard_Real X0,const Standard_Real L,const Standard_Real Tol) ;

//! This is Integral(X0,X,F(X,D)) - L <br>
Standard_EXPORT   Standard_Boolean Value(const Standard_Real X,Standard_Real& F) ;

//! This is F(X,D) <br>
Standard_EXPORT   Standard_Boolean Derivative(const Standard_Real X,Standard_Real& Df) ;


Standard_EXPORT   Standard_Boolean Values(const Standard_Real X,Standard_Real& F,Standard_Real& Df) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
CPnts_MyGaussFunction myFunction;
Standard_Real myX0;
Standard_Real myL;
Standard_Integer myOrder;
Standard_Real myTol;


};


#include <CPnts_MyRootFunction.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
