// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic3d_VertexNC_HeaderFile
#define _Graphic3d_VertexNC_HeaderFile

#ifndef _Quantity_Color_HeaderFile
#include <Quantity_Color.hxx>
#endif
#ifndef _Graphic3d_VertexN_HeaderFile
#include <Graphic3d_VertexN.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Quantity_Color;
class Graphic3d_Vertex;
class Graphic3d_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows the creation of a vertex with <br>
//!	    a colour and a 3D normal. <br>
class Graphic3d_VertexNC  : public Graphic3d_VertexN {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a point with coordinates 0.0, 0.0, 0.0 <br>
//!	    for which the normal is 0.0, 0.0, 1.0 and <br>
//!	    the colour is Quantity_NOC_WHITE. <br>
Standard_EXPORT Graphic3d_VertexNC();

//! Creates a point with coordinates <AX>, <AY>, <AZ> <br>
//!	    for which the normal is <ANX>, <ANY>, <ANZ> and <br>
//!	    the colour is <AColor>. <br>
//!	    If <FlagNormalise> is True the normal is already normalised <br>
//!	    Else the normal is not normalised, the graphic do it. <br>
Standard_EXPORT Graphic3d_VertexNC(const Standard_Real AX,const Standard_Real AY,const Standard_Real AZ,const Standard_Real ANX,const Standard_Real ANY,const Standard_Real ANZ,const Quantity_Color& AColor,const Standard_Boolean FlagNormalise = Standard_True);

//! Creates a point in <APoint> for which the normal <br>
//!	    is <AVector> and the colour is <AColor>. <br>
//!	    If <FlagNormalise> is True the normal is already normalised <br>
//!	    Else the normal is not normalised, the graphic do it. <br>
Standard_EXPORT Graphic3d_VertexNC(const Graphic3d_Vertex& APoint,const Graphic3d_Vector& AVector,const Quantity_Color& AColor,const Standard_Boolean FlagNormalise = Standard_True);

//! Modifies the colour of the point <me>. <br>
Standard_EXPORT   void SetColor(const Quantity_Color& ColorNew) ;

//! Returns the colour of the point <me>. <br>
Standard_EXPORT   Quantity_Color Color() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Quantity_Color MyColor;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
