// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Intrv_Interval_HeaderFile
#define _Intrv_Interval_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Intrv_Position_HeaderFile
#include <Intrv_Position.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!               **-----------****             Other <br>
//!   ***---*                                   IsBefore <br>
//!   ***----------*                            IsJustBefore <br>
//!   ***---------------*                       IsOverlappingAtStart <br>
//!   ***------------------------*              IsJustEnclosingAtEnd <br>
//!   ***-----------------------------------*   IsEnclosing <br>
//!              ***----*                       IsJustOverlappingAtStart <br>
//!              ***-------------*              IsSimilar <br>
//!              ***------------------------*   IsJustEnclosingAtStart <br>
//!                     ***-*                   IsInside <br>
//!                     ***------*              IsJustOverlappingAtEnd <br>
//!                     ***-----------------*   IsOverlappingAtEnd <br>
//!                              ***--------*   IsJustAfter <br>
//!                                   ***---*   IsAfter <br>
class Intrv_Interval  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Intrv_Interval();


Standard_EXPORT Intrv_Interval(const Standard_Real Start,const Standard_Real End);


Standard_EXPORT Intrv_Interval(const Standard_Real Start,const Standard_ShortReal TolStart,const Standard_Real End,const Standard_ShortReal TolEnd);

  Standard_Real Start() const;

  Standard_Real End() const;

  Standard_ShortReal TolStart() const;

  Standard_ShortReal TolEnd() const;

  void Bounds(Standard_Real& Start,Standard_ShortReal& TolStart,Standard_Real& End,Standard_ShortReal& TolEnd) const;

  void SetStart(const Standard_Real Start,const Standard_ShortReal TolStart) ;

//!             ****+****-------------------->      Old one <br>
//!         ****+****------------------------>      New one to fuse <br>
//!         <<<     <<< <br>
//!         ****+****------------------------>      result <br>
  void FuseAtStart(const Standard_Real Start,const Standard_ShortReal TolStart) ;

//!                      ****+****----------->      Old one <br>
//!         <----------**+**                        Tool for cutting <br>
//!                    >>>     >>> <br>
//!                      ****+****----------->      result <br>
  void CutAtStart(const Standard_Real Start,const Standard_ShortReal TolStart) ;

  void SetEnd(const Standard_Real End,const Standard_ShortReal TolEnd) ;

//!         <---------------------****+****      Old one <br>
//!         <-----------------**+**              New one to fuse <br>
//!                             >>>     >>> <br>
//!         <---------------------****+****      result <br>
  void FuseAtEnd(const Standard_Real End,const Standard_ShortReal TolEnd) ;

//!         <-----****+****                      Old one <br>
//!                     **+**------>             Tool for cutting <br>
//!               <<<     <<< <br>
//!         <-----****+****                      result <br>
  void CutAtEnd(const Standard_Real End,const Standard_ShortReal TolEnd) ;
//! True if myStart+myTolStart > myEnd-myTolEnd <br>
//!            or if myEnd+myTolEnd > myStart-myTolStart <br>
  Standard_Boolean IsProbablyEmpty() const;

//! True if me is Before Other <br>
//!                 **-----------****             Other <br>
//!   ***-----*                                   Before <br>
//!   ***------------*                            JustBefore <br>
//!   ***-----------------*                       OverlappingAtStart <br>
//!   ***--------------------------*              JustEnclosingAtEnd <br>
//!   ***-------------------------------------*   Enclosing <br>
//!                ***----*                       JustOverlappingAtStart <br>
//!                ***-------------*              Similar <br>
//!                ***------------------------*   JustEnclosingAtStart <br>
//!                       ***-*                   Inside <br>
//!                       ***------*              JustOverlappingAtEnd <br>
//!                       ***-----------------*   OverlappingAtEnd <br>
//!                                ***--------*   JustAfter <br>
//!                                     ***---*   After <br>
Standard_EXPORT   Intrv_Position Position(const Intrv_Interval& Other) const;
//! True if me is Before Other <br>
//!          ***----------------**                              me <br>
//!                                  **-----------****          Other <br>
  Standard_Boolean IsBefore(const Intrv_Interval& Other) const;
//! True if me is After Other <br>
//!                                  **-----------****          me <br>
//!          ***----------------**                              Other <br>
  Standard_Boolean IsAfter(const Intrv_Interval& Other) const;
//! True if me is Inside Other <br>
//!                  **-----------****                          me <br>
//!          ***--------------------------**                    Other <br>
  Standard_Boolean IsInside(const Intrv_Interval& Other) const;
//! True if me is Enclosing Other <br>
//!        ***----------------------------****                  me <br>
//!              ***------------------**                        Other <br>
  Standard_Boolean IsEnclosing(const Intrv_Interval& Other) const;
//! True if me is just Enclosing Other at start <br>
//!               ***---------------------------****            me <br>
//!              ***------------------**                        Other <br>
  Standard_Boolean IsJustEnclosingAtStart(const Intrv_Interval& Other) const;
//! True if me is just Enclosing Other at End <br>
//!        ***----------------------------****                  me <br>
//!                  ***-----------------****                   Other <br>
  Standard_Boolean IsJustEnclosingAtEnd(const Intrv_Interval& Other) const;
//! True if me is just before Other <br>
//!        ***--------****                                      me <br>
//!                     ***-----------**                        Other <br>
  Standard_Boolean IsJustBefore(const Intrv_Interval& Other) const;
//! True if me is just after Other <br>
//!                     ****-------****                         me <br>
//!        ***-----------**                                     Other <br>
  Standard_Boolean IsJustAfter(const Intrv_Interval& Other) const;
//! True if me is overlapping Other at start <br>
//!        ***---------------***                                me <br>
//!                     ***-----------**                        Other <br>
  Standard_Boolean IsOverlappingAtStart(const Intrv_Interval& Other) const;
//! True if me is overlapping Other at end <br>
//!                     ***-----------**                        me <br>
//!        ***---------------***                                Other <br>
  Standard_Boolean IsOverlappingAtEnd(const Intrv_Interval& Other) const;
//! True if me is just overlapping Other at start <br>
//!        ***-----------***                                    me <br>
//!        ***------------------------**                        Other <br>
  Standard_Boolean IsJustOverlappingAtStart(const Intrv_Interval& Other) const;
//! True if me is just overlapping Other at end <br>
//!                     ***-----------*                         me <br>
//!        ***------------------------**                        Other <br>
  Standard_Boolean IsJustOverlappingAtEnd(const Intrv_Interval& Other) const;
//! True if me and Other have the same bounds <br>
//!         *----------------***                                me <br>
//!        ***-----------------**                               Other <br>
  Standard_Boolean IsSimilar(const Intrv_Interval& Other) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myStart;
Standard_Real myEnd;
Standard_ShortReal myTolStart;
Standard_ShortReal myTolEnd;


};


#include <Intrv_Interval.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
