// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_Chronometer_HeaderFile
#define _OSD_Chronometer_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class measures CPU time both for user and system. <br>
class OSD_Chronometer  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes a stopped Chronometer. <br>
Standard_EXPORT OSD_Chronometer();


Standard_EXPORT virtual  void Destroy() ;
Standard_EXPORT virtual ~OSD_Chronometer() {Destroy() ;}

//! Stops and Reinitializes the Chronometer. <br>
Standard_EXPORT virtual  void Reset() ;

//! Stops the Chronometer. <br>
Standard_EXPORT virtual  void Stop() ;

//! Starts (after Create or Reset) or restarts (after Stop) <br>
//!          the chronometer. <br>
Standard_EXPORT virtual  void Start() ;

//! Shows the current CPU user and system time on the <br>
//!          standard output stream <cout>. <br>
//!          The chronometer can be running (laps Time) or stopped. <br>
Standard_EXPORT virtual  void Show() ;

//! Shows the current CPU user and system time on the output <br>
//!          stream <os>. <br>
//!          The chronometer can be running (laps Time) or stopped. <br>
Standard_EXPORT virtual  void Show(Standard_OStream& os) ;

//! Returns the current CPU user time in a variable. <br>
//!          The chronometer can be running (laps Time) or stopped. <br>
Standard_EXPORT   void Show(Standard_Real& UserSeconds) ;

//! Returns the current CPU user and system time in variables. <br>
//!          The chronometer can be running (laps Time) or stopped. <br>
Standard_EXPORT   void Show(Standard_Real& UserSeconds,Standard_Real& SystemSeconds) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Boolean Stopped;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real Cumul_user;
Standard_Real Cumul_sys;
Standard_Address RefToInitialTMS;
Standard_Address RefToCurrentTMS;
Standard_Address RefToInitialTMSUser;
Standard_Address RefToCurrentTMSUser;
Standard_Address RefToInitialTMSKrnl;
Standard_Address RefToCurrentTMSKrnl;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
