// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _STEPConstruct_HeaderFile
#define _STEPConstruct_HeaderFile

#ifndef _Handle_StepRepr_RepresentationItem_HeaderFile
#include <Handle_StepRepr_RepresentationItem.hxx>
#endif
#ifndef _Handle_Transfer_FinderProcess_HeaderFile
#include <Handle_Transfer_FinderProcess.hxx>
#endif
#ifndef _Handle_Transfer_TransientProcess_HeaderFile
#include <Handle_Transfer_TransientProcess.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Transfer_Binder_HeaderFile
#include <Handle_Transfer_Binder.hxx>
#endif
#ifndef _Handle_StepShape_ShapeDefinitionRepresentation_HeaderFile
#include <Handle_StepShape_ShapeDefinitionRepresentation.hxx>
#endif
#ifndef _Handle_StepShape_ContextDependentShapeRepresentation_HeaderFile
#include <Handle_StepShape_ContextDependentShapeRepresentation.hxx>
#endif
class StepRepr_RepresentationItem;
class Transfer_FinderProcess;
class TopoDS_Shape;
class TopLoc_Location;
class Transfer_TransientProcess;
class Transfer_Binder;
class StepShape_ShapeDefinitionRepresentation;
class StepShape_ContextDependentShapeRepresentation;
class STEPConstruct_Tool;
class STEPConstruct_UnitContext;
class STEPConstruct_Part;
class STEPConstruct_Assembly;
class STEPConstruct_Styles;
class STEPConstruct_ValidationProps;
class STEPConstruct_ExternRefs;
class STEPConstruct_AP203Context;
class STEPConstruct_ContextTool;
class STEPConstruct_DataMapOfAsciiStringTransient;
class STEPConstruct_PointHasher;
class STEPConstruct_DataMapOfPointTransient;
class STEPConstruct_DataMapNodeOfDataMapOfAsciiStringTransient;
class STEPConstruct_DataMapIteratorOfDataMapOfAsciiStringTransient;
class STEPConstruct_DataMapNodeOfDataMapOfPointTransient;
class STEPConstruct_DataMapIteratorOfDataMapOfPointTransient;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Defines tools for creation and investigation STEP constructs <br>
//!          used for representing various kinds of data, such as product and <br>
//!          assembly structure, unit contexts, associated information <br>
//!          The creation of these structures is made according to currently <br>
//!          active schema (AP203 or AP214 CD2 or DIS) <br>
//!          This is taken from parameter write.step.schema <br>
class STEPConstruct  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns STEP entity of the (sub)type of RepresentationItem <br>
//!          which is a result of the tranalation of the Shape, or Null if <br>
//!          no result is recorded <br>
Standard_EXPORT static  Handle_StepRepr_RepresentationItem FindEntity(const Handle(Transfer_FinderProcess)& FinderProcess,const TopoDS_Shape& Shape) ;

//! The same as above, but in the case if item not found, repeats <br>
//!          search on the same shape without location. The Loc corresponds to the <br>
//!          location with which result is found (either location of the Shape, <br>
//!          or Null) <br>
Standard_EXPORT static  Handle_StepRepr_RepresentationItem FindEntity(const Handle(Transfer_FinderProcess)& FinderProcess,const TopoDS_Shape& Shape,TopLoc_Location& Loc) ;

//! Returns Shape resulting from given STEP entity (Null if not mapped) <br>
Standard_EXPORT static  TopoDS_Shape FindShape(const Handle(Transfer_TransientProcess)& TransientProcess,const Handle(StepRepr_RepresentationItem)& item) ;

//! Find CDSR correcponding to the component in the specified assembly <br>
Standard_EXPORT static  Standard_Boolean FindCDSR(const Handle(Transfer_Binder)& ComponentBinder,const Handle(StepShape_ShapeDefinitionRepresentation)& AssemblySDR,Handle(StepShape_ContextDependentShapeRepresentation)& ComponentCDSR) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class STEPConstruct_Tool;
friend class STEPConstruct_UnitContext;
friend class STEPConstruct_Part;
friend class STEPConstruct_Assembly;
friend class STEPConstruct_Styles;
friend class STEPConstruct_ValidationProps;
friend class STEPConstruct_ExternRefs;
friend class STEPConstruct_AP203Context;
friend class STEPConstruct_ContextTool;
friend class STEPConstruct_DataMapOfAsciiStringTransient;
friend class STEPConstruct_PointHasher;
friend class STEPConstruct_DataMapOfPointTransient;
friend class STEPConstruct_DataMapNodeOfDataMapOfAsciiStringTransient;
friend class STEPConstruct_DataMapIteratorOfDataMapOfAsciiStringTransient;
friend class STEPConstruct_DataMapNodeOfDataMapOfPointTransient;
friend class STEPConstruct_DataMapIteratorOfDataMapOfPointTransient;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
