// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_ComposeShell_HeaderFile
#define _ShapeFix_ComposeShell_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeFix_ComposeShell_HeaderFile
#include <Handle_ShapeFix_ComposeShell.hxx>
#endif

#ifndef _Handle_ShapeExtend_CompositeSurface_HeaderFile
#include <Handle_ShapeExtend_CompositeSurface.hxx>
#endif
#ifndef _TopLoc_Location_HeaderFile
#include <TopLoc_Location.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_ShapeAnalysis_TransferParameters_HeaderFile
#include <Handle_ShapeAnalysis_TransferParameters.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _ShapeFix_Root_HeaderFile
#include <ShapeFix_Root.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
#ifndef _Handle_ShapeExtend_WireData_HeaderFile
#include <Handle_ShapeExtend_WireData.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
class ShapeExtend_CompositeSurface;
class ShapeAnalysis_TransferParameters;
class TopLoc_Location;
class TopoDS_Face;
class TopoDS_Shape;
class ShapeFix_SequenceOfWireSegment;
class ShapeExtend_WireData;
class gp_Lin2d;
class ShapeFix_WireSegment;
class TColStd_SequenceOfInteger;
class TColStd_SequenceOfReal;
class TopTools_SequenceOfShape;
class Geom_Surface;


//! This class is intended to create a shell from the composite <br>
//!          surface (grid of surfaces) and set of wires. <br>
//!          It may be either division of the supporting surface of the <br>
//!          face, or creating a shape corresponding to face on composite <br>
//!          surface which is missing in CAS.CADE but exists in some other <br>
//!          systems. <br>
class ShapeFix_ComposeShell : public ShapeFix_Root {

public:
 // Methods PUBLIC
 // 

//! Creates empty tool. <br>
Standard_EXPORT ShapeFix_ComposeShell();

//! Initializes with composite surface, face and precision. <br>
//!          Here face defines both set of wires and way of getting <br>
//!          pcurves. Precision is used (together with tolerance of edges) <br>
//!          for handling subtle cases, such as tangential intersections. <br>
Standard_EXPORT   void Init(const Handle(ShapeExtend_CompositeSurface)& Grid,const TopLoc_Location& L,const TopoDS_Face& Face,const Standard_Real Prec) ;

//! Returns (modifiable) flag for special 'closed' <br>
//!          mode which forces ComposeShell to consider <br>
//!          all pcurves on closed surface as modulo period. <br>
//!          This can reduce reliability, but allows to deal <br>
//!          with wires closed in 3d but open in 2d (missing seam) <br>
//!          Default is False <br>
Standard_EXPORT   Standard_Boolean& ClosedMode() ;

//! Performs the work on already loaded data. <br>
Standard_EXPORT virtual  Standard_Boolean Perform() ;

//! Splits edges in the original shape by grid. <br>
//!          This is a part of Perform() which does not produce any <br>
//!          resulting shape; the only result is filled context <br>
//!          where splittings are recorded. <br>
Standard_EXPORT   void SplitEdges() ;

//! Returns resulting shell or face (or Null shape if not done) <br>
Standard_EXPORT  const TopoDS_Shape& Result() const;

//! Queries status of last call to Perform() <br>
//! OK   : nothing done (some kind of error) <br>
//! DONE1: splitting is done, at least one new face created <br>
//! DONE2: splitting is done, several new faces obtained <br>
//! FAIL1: misoriented wire encountered (handled) <br>
//! FAIL2: recoverable parity error <br>
//! FAIL3: edge with no pcurve on supporting face <br>
//! FAIL4: unrecoverable algorithm error (parity check) <br>
Standard_EXPORT   Standard_Boolean Status(const ShapeExtend_Status status) const;

//! Creates new faces from the set of (closed) wires. Each wire <br>
//!          is put on corresponding patch in the composite surface, <br>
//!          and all pcurves on the initial (pseudo)face are reassigned to <br>
//!          that surface. If several wires are one inside another, single <br>
//!          face is created. <br>
Standard_EXPORT   void DispatchWires(TopTools_SequenceOfShape& faces,ShapeFix_SequenceOfWireSegment& wires) const;

//! Sets tool for transfer parameters from 3d to 2d and vice versa. <br>
Standard_EXPORT   void SetTransferParamTool(const Handle(ShapeAnalysis_TransferParameters)& TransferParam) ;

//! Gets tool for transfer parameters from 3d to 2d and vice versa. <br>
Standard_EXPORT   Handle_ShapeAnalysis_TransferParameters GetTransferParamTool() const;
//Standard_EXPORT ~ShapeFix_ComposeShell();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Fill sequence of wire segments by wires from myFace <br>
//!          (pre-loaded). It performs reorder so that edges in segments <br>
//!          are well-ordered. The context is applied to all wires <br>
//!          before using them. <br>
Standard_EXPORT   void LoadWires(ShapeFix_SequenceOfWireSegment& seqw) const;

//! Analyze tangencies and compute orientation code for wire segment <br>
//!          between two intersections: tells if segment is on left or right side <br>
//!          of cutting line, or tangent to it (by several points recomputed to 3d, <br>
//!          distance is compared with tolerance of corresponding edge). <br>
Standard_EXPORT   Standard_Integer ComputeCode(const Handle(ShapeExtend_WireData)& wire,const gp_Lin2d& line,const Standard_Integer begInd,const Standard_Integer endInd,const Standard_Real begPar,const Standard_Real endPar,const Standard_Boolean IsInternal = Standard_False) ;

//! Splits edges in the wire by given indices of edges and <br>
//!          parameters on them. Returns resulting wire and vertices <br>
//!          corresponding to splitting parameters. If two consequtive <br>
//!          splitting points are too near one to another (with tolerance <br>
//!          of edge), edge is divided in single point. In the same way, <br>
//!          splitting which is too near to end of edge, is not applied <br>
//!          (end vertex is returned instead). <br>
Standard_EXPORT   ShapeFix_WireSegment SplitWire(ShapeFix_WireSegment& wire,TColStd_SequenceOfInteger& indexes,const TColStd_SequenceOfReal& values,TopTools_SequenceOfShape& vertices,const TColStd_SequenceOfInteger& segcodes,const Standard_Boolean cutbyu,const Standard_Integer cutindex) ;

//! Split edges in the wire by cutting line. <br>
//!          Wires with FORWARD or REVERSED orientation are considered <br>
//!          as closed. <br>
Standard_EXPORT   Standard_Boolean SplitByLine(ShapeFix_WireSegment& wire,const gp_Lin2d& line,const Standard_Boolean cutbyu,const Standard_Integer cutindex,TColStd_SequenceOfReal& SplitLinePar,TColStd_SequenceOfInteger& SplitLineCode,TopTools_SequenceOfShape& SplitLineVertex) ;

//! Split edges in the sequence of wires by cutting line. <br>
//!          Wires with FORWARD or REVERSED orientation are considered <br>
//!          as closed. <br>
Standard_EXPORT   void SplitByLine(ShapeFix_SequenceOfWireSegment& seqw,const gp_Lin2d& line,const Standard_Boolean cutbyu,const Standard_Integer cutindex) ;

//! Split initial set of (closed) wires by grid of lines corresponding <br>
//!          to joints between patches on the composite surface. <br>
//!          Parts of joint lines which get inside the face are also added <br>
//!          into the sequence as wires with orientation EXTERNAL. <br>
//!          They share common vertices with all wires they intersect. <br>
//!          All modifications (splitting) are recorded in context, <br>
//!          except splitting of joint edge itself and wires marked as <br>
//!          EXTERNAL (they supposed to be another joint edges). <br>
Standard_EXPORT   void SplitByGrid(ShapeFix_SequenceOfWireSegment& seqw) ;

//! Break wires into open wire segments by common vertices <br>
//!          (splitting points), so that each segment is either closed and <br>
//!          not touching others, or touches others at ends (have common <br>
//!          vertices). <br>
//!          After that, each wire segment lies on its own patch of grid. <br>
Standard_EXPORT   void BreakWires(ShapeFix_SequenceOfWireSegment& seqw) ;

//! Collect set of wire segments (already splitted) into closed <br>
//!          wires. This is done by traversing all the segments in allowed <br>
//!          directions, starting only from the REVERSED and FORWARD and <br>
//!          taking EXTERNAL as necessary in fork points. Forks are detected <br>
//!          by common vertices. In fork point, most left way is seleccted <br>
//!          among all possible ways. <br>
Standard_EXPORT   void CollectWires(ShapeFix_SequenceOfWireSegment& wires,ShapeFix_SequenceOfWireSegment& seqw) ;

//! Creates new faces on one path of grid. It dispatches given loops <br>
//!          (wires) into one or several faces depending on their mutual <br>
//!          position. <br>
Standard_EXPORT   void MakeFacesOnPatch(TopTools_SequenceOfShape& faces,const Handle(Geom_Surface)& surf,TopTools_SequenceOfShape& loops) const;


 // Fields PROTECTED
 //
TopAbs_Orientation myOrient;
TopoDS_Shape myResult;
Standard_Integer myStatus;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_ShapeExtend_CompositeSurface myGrid;
TopLoc_Location myLoc;
TopoDS_Face myFace;
Standard_Real myUResolution;
Standard_Real myVResolution;
Handle_ShapeAnalysis_TransferParameters myTransferParamTool;
Standard_Boolean myInvertEdgeStatus;
Standard_Boolean myClosedMode;
Standard_Boolean myUClosed;
Standard_Boolean myVClosed;
Standard_Real myUPeriod;
Standard_Real myVPeriod;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
