// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_Unit_HeaderFile
#define _Units_Unit_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Units_Unit_HeaderFile
#include <Handle_Units_Unit.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_Units_StringsSequence_HeaderFile
#include <Handle_Units_StringsSequence.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Units_Quantity_HeaderFile
#include <Handle_Units_Quantity.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Handle_Units_Token_HeaderFile
#include <Handle_Units_Token.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TCollection_HAsciiString;
class Units_StringsSequence;
class Units_Quantity;
class Units_Token;


//! This class defines an elementary word contained in <br>
//!          a physical quantity. <br>
class Units_Unit : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates  and returns a  unit.  <aname> is  the name of <br>
//!          the  unit, <asymbol> is the  usual abbreviation of the <br>
//!          unit,  and  <avalue> is the  value in relation to  the <br>
//!          International System of Units. <br>
Standard_EXPORT Units_Unit(const Standard_CString aname,const Standard_CString asymbol,const Standard_Real avalue,const Handle(Units_Quantity)& aquantity);

//! Creates  and returns a  unit.  <aname> is  the name of <br>
//!          the  unit, <asymbol> is the  usual abbreviation of the <br>
//!          unit. <br>
Standard_EXPORT Units_Unit(const Standard_CString aname,const Standard_CString asymbol);

//! Creates  and returns a  unit.  <aname> is  the name of <br>
//!          the  unit. <br>
Standard_EXPORT Units_Unit(const Standard_CString aname);
//! Returns the name of the unit <thename> <br>
  TCollection_AsciiString Name() const;

//! Adds a new symbol <asymbol> attached to <me>. <br>
Standard_EXPORT   void Symbol(const Standard_CString asymbol) ;
//! Returns the  value in relation  with the International <br>
//!          System of Units. <br>
  Standard_Real Value() const;
//! Returns <thequantity> contained in <me>. <br>
  Handle_Units_Quantity Quantity() const;
//! Returns the sequence of symbols <thesymbolssequence> <br>
  Handle_Units_StringsSequence SymbolsSequence() const;
//! Sets the value <avalue> to <me>. <br>
  void Value(const Standard_Real avalue) ;
//! Sets the physical Quantity <aquantity> to <me>. <br>
  void Quantity(const Handle(Units_Quantity)& aquantity) ;

//! Starting with <me>, returns a new Token object. <br>
Standard_EXPORT virtual  Handle_Units_Token Token() const;

//! Compares all the symbols  linked  within <me> with the <br>
//!          name of <atoken>,  and returns  True  if there is  one <br>
//!          symbol equal to the name, False otherwise. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const Standard_CString astring) const;
friend Standard_EXPORT Standard_Boolean operator ==(const Handle(Units_Unit)&,const Standard_CString);

//! Useful for debugging <br>
Standard_EXPORT virtual  void Dump(const Standard_Integer ashift,const Standard_Integer alevel) const;
//Standard_EXPORT ~Units_Unit();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Handle_Units_StringsSequence thesymbolssequence;
Standard_Real thevalue;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString thename;
Handle_Units_Quantity thequantity;


};


#include <Units_Unit.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
