/* MAPERM.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <ApproxF2var.h>
#else
#define __ApproxF2var_API
#endif
/* Subroutine */ __ApproxF2var_API int mmaperm_(ncofmx, ndim, ncoeff, iordre, crvjac, ncfnew, 
	errmoy)
integer *ncofmx, *ndim, *ncoeff, *iordre;
doublereal *crvjac;
integer *ncfnew;
doublereal *errmoy;
{
    /* System generated locals */
    integer crvjac_dim1, crvjac_offset, i__1, i__2;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static doublereal bidj;
    static integer i__, ia, nd, ncfcut, ibb;
    static doublereal bid;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*        Calcule la racine carree de l' erreur quadratique moyenne */
/*        d' approximation faite lorsque l' on ne conserve que les */
/*        premiers NCFNEW coefficients d' une courbe de degre NCOEFF-1 */
/*        ecrite dans la base de Jacobi NORMALISEE d' ordre */
/*        2*(IORDRE+1). */

/*     MOTS CLES : */
/*     ----------- */
/*        LEGENDRE,POLYGONE,APPROXIMATION,ERREUR. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        NCOFMX : Degre maximum de la courbe. */
/*        NDIM   : Dimension de l' espace. */
/*        NCOEFF : Le degre +1 de la courbe. */
/*        IORDRE : Ordre de contrainte de continuite aux extremites. */
/*        CRVJAC : La courbe dont on veut baisser le degre. */
/*        NCFNEW : Le degre +1 du polynome resultat. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        ERRMOY : La precision moyenne de l' approximation. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     23-12-1989 : RBD ; Creation */

/* > */
/* ***********************************************************************
 */

/*   Le nom de la routine */

    /* Parameter adjustments */
    crvjac_dim1 = *ncofmx;
    crvjac_offset = crvjac_dim1 + 1;
    crvjac -= crvjac_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 2) {
	mgenmsg_("MMAPERM", 7L);
    }

/* --------- Degre minimum pouvant etre atteint : Arret a 1 ou IA ------- 
*/

    ia = (*iordre + 1) << 1;
    ncfcut = ia + 1;
    if (*ncfnew + 1 > ncfcut) {
	ncfcut = *ncfnew + 1;
    }

/* -------------- Elimination des coefficients de haut degre ------------ 
*/
/* ----------- Boucle sur la serie de Jacobi :NCFCUT --> NCOEFF --------- 
*/

    *errmoy = 0.;
    bid = 0.;
    i__1 = *ndim;
    for (nd = 1; nd <= i__1; ++nd) {
	i__2 = *ncoeff;
	for (i__ = ncfcut; i__ <= i__2; ++i__) {
	    bidj = crvjac[i__ + nd * crvjac_dim1];
	    bid += bidj * bidj;
/* L200: */
	}
/* L100: */
    }

/* ----------- Racine carree de l' erreur quadratique moyenne ----------- 
*/

    bid /= 2.;
    *errmoy = sqrt(bid);

/* ------------------------------- The end ------------------------------ 
*/

    if (ibb >= 2) {
	mgsomsg_("MMAPERM", 7L);
    }
    return 0;
} /* mmaperm_ */

