/* MAPCMP.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mmapcmp_(ndim, ncofmx, ncoeff, crvold, crvnew)
integer *ndim, *ncofmx, *ncoeff;
doublereal *crvold, *crvnew;
{
    /* System generated locals */
    integer crvold_dim1, crvold_offset, crvnew_dim1, crvnew_offset, i__1, 
	    i__2;

    /* Local variables */
    static integer ipair, nd, ndegre, impair, ibb, idg;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*        Compression de la courbe CRVOLD en un tableau comprenant */
/*        les coeff. de rang pair : CRVNEW(*,0,*) */
/*        et de rang impair : CRVNEW(*,1,*). */

/*     MOTS CLES : */
/*     ----------- */
/*        COMPRESSION,COURBE. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*     NDIM   : Dimension de l' espace. */
/*     NCOFMX : Le nbre maximum de coeff. de la courbe a compacter. */
/*     NCOEFF : Le nbre maximum de coeff. de la courbe compactee. */
/*     CRVOLD : La courbe (0:NCOFMX-1,NDIM) a compacter. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*     CRVNEW : La coube compactee en (0:(NCOEFF-1)/2,0,NDIM) (contenant 
*/
/*              les termes pairs) et en (0:(NCOEFF-1)/2,1,NDIM) */
/*              (contenant les termes impairs). */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     Cette routine est utile pour preparer les coefficients d' une */
/*     courbe dans une base orthogonale (Legendre ou Jacobi) avant de */
/*     calculer les coefficients dans la base canonique [-1,1] par */
/*     MMJACAN. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     12-04-1989 : RBD ; Creation. */
/* > */
/* ***********************************************************************
 */

/*   Le nom de la routine */

    /* Parameter adjustments */
    crvold_dim1 = *ncofmx;
    crvold_offset = crvold_dim1;
    crvold -= crvold_offset;
    crvnew_dim1 = (*ncoeff - 1) / 2 + 1;
    crvnew_offset = crvnew_dim1 << 1;
    crvnew -= crvnew_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMAPCMP", 7L);
    }

    ndegre = *ncoeff - 1;
    i__1 = *ndim;
    for (nd = 1; nd <= i__1; ++nd) {
	ipair = 0;
	i__2 = ndegre / 2;
	for (idg = 0; idg <= i__2; ++idg) {
	    crvnew[idg + (nd << 1) * crvnew_dim1] = crvold[ipair + nd * 
		    crvold_dim1];
	    ipair += 2;
/* L200: */
	}
	if (ndegre < 1) {
	    goto L400;
	}
	impair = 1;
	i__2 = (ndegre - 1) / 2;
	for (idg = 0; idg <= i__2; ++idg) {
	    crvnew[idg + ((nd << 1) + 1) * crvnew_dim1] = crvold[impair + nd *
		     crvold_dim1];
	    impair += 2;
/* L300: */
	}

L400:
/* L100: */
	;
    }

/* ---------------------------------- The end --------------------------- 
*/

    if (ibb >= 3) {
	mgsomsg_("MMAPCMP", 7L);
    }
    return 0;
} /* mmapcmp_ */

