// File:	StepToGeom_MakeConic.cxx
// Created:	Fri Jul  2 16:51:20 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
//:p0 abv 19.02.99: management of 'done' flag improved

#include <StepToGeom_MakeConic.ixx>
#include <StdFail_NotDone.hxx>
#include <StepToGeom_MakeConic.hxx>
#include <StepGeom_Conic.hxx>
#include <StepGeom_Circle.hxx>
#include <StepToGeom_MakeCircle.hxx>
#include <StepGeom_Ellipse.hxx>
#include <StepToGeom_MakeEllipse.hxx>
#include <StepGeom_Hyperbola.hxx>
#include <StepToGeom_MakeHyperbola.hxx>
#include <StepGeom_Parabola.hxx>
#include <StepToGeom_MakeParabola.hxx>

//=============================================================================
// Creation d' une Conic de Geom a partir d' une Conic de Step
//=============================================================================

StepToGeom_MakeConic::StepToGeom_MakeConic ( const Handle(StepGeom_Conic)& C)
{
  done = Standard_False;
  if (C->IsKind(STANDARD_TYPE(StepGeom_Circle))) {
    Handle(StepGeom_Circle) Cir = Handle(StepGeom_Circle)::DownCast(C);
    StepToGeom_MakeCircle MkCircle(Cir);
    if ( MkCircle.IsDone() ) theConic = MkCircle.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Ellipse))) {
    Handle(StepGeom_Ellipse) Ell = Handle(StepGeom_Ellipse)::DownCast(C);
    StepToGeom_MakeEllipse MkEllipse(Ell);
    if ( MkEllipse.IsDone() ) theConic = MkEllipse.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Hyperbola))) {
    Handle(StepGeom_Hyperbola) Hyp = Handle(StepGeom_Hyperbola)::DownCast(C);
    StepToGeom_MakeHyperbola MkHyperbola(Hyp);
    if ( MkHyperbola.IsDone() ) theConic = MkHyperbola.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Parabola))) {
    Handle(StepGeom_Parabola) Par = Handle(StepGeom_Parabola)::DownCast(C);
    StepToGeom_MakeParabola MkParabola(Par);
    if ( MkParabola.IsDone() ) theConic = MkParabola.Value();
  }
  // Attention : Other conic shall be implemented !
  done = ! theConic.IsNull();
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Conic) &
      StepToGeom_MakeConic::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theConic;
}
