// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Aspect_FontMapEntry_HeaderFile
#define _Aspect_FontMapEntry_HeaderFile

#ifndef _Aspect_FontStyle_HeaderFile
#include <Aspect_FontStyle.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_OutOfRange;
class Aspect_BadAccess;
class Aspect_FontStyle;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class defines a fontmap entry. <br>
//!	    A fontmap entry is an association beetwen <br>
//!	    a FontStyle object and an index in the fontmap. <br>
class Aspect_FontMapEntry  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an unallocated fontmap entry <br>
Standard_EXPORT Aspect_FontMapEntry();

//! Creates an allocated fontmap entry <br>
Standard_EXPORT Aspect_FontMapEntry(const Standard_Integer index,const Aspect_FontStyle& style);

//! Creates an allocated fontmap entry. <br>
//!  Warning: Raises error if the fontmap entry <entry> is unallocated. <br>
Standard_EXPORT Aspect_FontMapEntry(const Aspect_FontMapEntry& entry);

//! Sets fontmap entry value and allocates it. <br>
Standard_EXPORT   void SetValue(const Standard_Integer index,const Aspect_FontStyle& style) ;

//! Sets fontmap entry value and allocates it. <br>
Standard_EXPORT   void SetValue(const Aspect_FontMapEntry& entry) ;
  void operator =(const Aspect_FontMapEntry& entry) 
{
  SetValue(entry);
}


//! Sets the line style of fontmap entry. <br>
Standard_EXPORT   void SetType(const Aspect_FontStyle& Style) ;


Standard_EXPORT  const Aspect_FontStyle& Type() const;

//! Sets index value of a fontmap entry. <br>
Standard_EXPORT   void SetIndex(const Standard_Integer index) ;


Standard_EXPORT   Standard_Integer Index() const;

//! Unallocates the fontmap entry. <br>
Standard_EXPORT   void Free() ;

//! Returns True if the fontmap entry is allocated. <br>
//!  Warning: A fontmap entry is allocated when the font and <br>
//!	    the index is defined. <br>
Standard_EXPORT   Standard_Boolean IsAllocated() const;


Standard_EXPORT   void Dump() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Aspect_FontStyle MyType;
Standard_Integer MyIndex;
Standard_Boolean MyTypeIsDef;
Standard_Boolean MyIndexIsDef;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
