// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_ArgumentAnalyzer_HeaderFile
#define _BOP_ArgumentAnalyzer_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _BOP_Operation_HeaderFile
#include <BOP_Operation.hxx>
#endif
#ifndef _BOP_ListOfCheckResult_HeaderFile
#include <BOP_ListOfCheckResult.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class TopoDS_Shape;
class BOP_ListOfCheckResult;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! check the validity of argument(s) for Boolean Operations <br>
class BOP_ArgumentAnalyzer  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! empty constructor <br>
Standard_EXPORT BOP_ArgumentAnalyzer();

//! sets object shape <br>
Standard_EXPORT   void SetShape1(const TopoDS_Shape& TheShape) ;

//! sets tool shape <br>
Standard_EXPORT   void SetShape2(const TopoDS_Shape& TheShape) ;

//! returns object shape; <br>
Standard_EXPORT  const TopoDS_Shape& GetShape1() const;

//! returns tool shape <br>
Standard_EXPORT  const TopoDS_Shape& GetShape2() const;

//! returns ref <br>
Standard_EXPORT   BOP_Operation& OperationType() ;

//! returns ref <br>
Standard_EXPORT   Standard_Boolean& StopOnFirstFaulty() ;
//! Returns (modifiable) mode <br>
//!          that means checking types of shapes. <br>
  Standard_Boolean& ArgumentTypeMode() ;
//! Returns (modifiable) mode that means <br>
//!          checking of self-intersection of shapes. <br>
  Standard_Boolean& SelfInterMode() ;
//! Returns (modifiable) mode that means <br>
//!          checking of small edges. <br>
  Standard_Boolean& SmallEdgeMode() ;
//! Returns (modifiable) mode that means <br>
//!          checking of possibility to split or rebuild faces. <br>
  Standard_Boolean& RebuildFaceMode() ;
//! Returns (modifiable) mode that means <br>
//!          checking of tangency between subshapes. <br>
  Standard_Boolean& TangentMode() ;
//! Returns (modifiable) mode that means <br>
//!          checking of problem of merging vertices. <br>
  Standard_Boolean& MergeVertexMode() ;
//! Returns (modifiable) mode that means <br>
//!          checking of problem of merging edges. <br>
  Standard_Boolean& MergeEdgeMode() ;

//! performs analysis <br>
Standard_EXPORT   void Perform() ;

//! result of test <br>
Standard_EXPORT   Standard_Boolean HasFaulty() const;

//! returns a result of test <br>
Standard_EXPORT  const BOP_ListOfCheckResult& GetCheckResult() const;





protected:

 // Methods PROTECTED
 // 


Standard_EXPORT   void TestTypes() ;


Standard_EXPORT   void TestSelfInterferences() ;


Standard_EXPORT   void TestSmallEdge() ;


Standard_EXPORT   void TestRebuildFace() ;


Standard_EXPORT   void TestTangent() ;


Standard_EXPORT   void TestMergeSubShapes(const TopAbs_ShapeEnum theType) ;


Standard_EXPORT   void TestMergeVertex() ;


Standard_EXPORT   void TestMergeEdge() ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myShape1;
TopoDS_Shape myShape2;
Standard_Boolean myStopOnFirst;
BOP_Operation myOperation;
Standard_Boolean myArgumentTypeMode;
Standard_Boolean mySelfInterMode;
Standard_Boolean mySmallEdgeMode;
Standard_Boolean myRebuildFaceMode;
Standard_Boolean myTangentMode;
Standard_Boolean myMergeVertexMode;
Standard_Boolean myMergeEdgeMode;
BOP_ListOfCheckResult myResult;


};


#include <BOP_ArgumentAnalyzer.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
