// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgo_BooleanOperations_HeaderFile
#define _BRepAlgo_BooleanOperations_HeaderFile

#ifndef _BRepAlgo_DSAccess_HeaderFile
#include <BRepAlgo_DSAccess.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopTools_MapOfShape_HeaderFile
#include <TopTools_MapOfShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _Handle_TopOpeBRepDS_HDataStructure_HeaderFile
#include <Handle_TopOpeBRepDS_HDataStructure.hxx>
#endif
#ifndef _Handle_TopOpeBRepBuild_HBuilder_HeaderFile
#include <Handle_TopOpeBRepBuild_HBuilder.hxx>
#endif
class TopoDS_Shape;
class TopOpeBRepDS_HDataStructure;
class TopTools_ListOfShape;
class TopOpeBRepBuild_HBuilder;
class BRepAlgo_DSAccess;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BRepAlgo_BooleanOperations  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepAlgo_BooleanOperations();

//! S1 est un Shell dont TOUTES les faces ont pour support <br>
//!          la MEME surface. S2 est une Edge INCLUSE dans cette surface <br>
//!          avec pcurve. <br>
//!          cela vite une couteuse opration 3d, par rapport  Shapes. <br>
Standard_EXPORT   void Shapes2d(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;

//! Defines the arguments. <br>
Standard_EXPORT   void Shapes(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;

//! Sets different parameters for the curve approximations : <br>
//!          NbPntMax : Maximum number of points to be approximated at <br>
//!                     the same time in one curve. <br>
//!          Tol3D, Tol2D : Tolerances to be reached by the approximation. <br>
//!          RelativeTol : The given tolerances are relative. <br>
Standard_EXPORT   void SetApproxParameters(const Standard_Integer NbPntMax,const Standard_Real Tol3D,const Standard_Real Tol2D,const Standard_Boolean RelativeTol) ;


Standard_EXPORT   void Define(const TopoDS_Shape& S1,const TopoDS_Shape& S2,Handle(TopOpeBRepDS_HDataStructure)& HDS) ;

//! returns the common part of the shapes. <br>
Standard_EXPORT  const TopoDS_Shape& Common() ;

//! returns the fuse part of the shapes. <br>
Standard_EXPORT  const TopoDS_Shape& Fus() ;

//! returns the cut part of the shapes. <br>
Standard_EXPORT  const TopoDS_Shape& Cut() ;

//! returns the intersection of the shapes. <br>
Standard_EXPORT  const TopoDS_Shape& Section() ;

//! returns the result of the boolean operation. <br>
Standard_EXPORT  const TopoDS_Shape& Shape() ;

//! Returns the shape(s) resulting of the boolean operation <br>
//!          issued from the shape <S>. <br>
Standard_EXPORT  const TopoDS_Shape& ShapeFrom(const TopoDS_Shape& S) ;

//! Returns the list of the descendant shapes of the shape <S>. <br>
Standard_EXPORT  const TopTools_ListOfShape& Modified(const TopoDS_Shape& S) ;

//! Returns the fact that the shape <S> has been deleted or not <br>
//!          by the boolean operation. <br>
Standard_EXPORT   Standard_Boolean IsDeleted(const TopoDS_Shape& S) ;


Standard_EXPORT  const Handle_TopOpeBRepDS_HDataStructure& DataStructure() const;


Standard_EXPORT   Handle_TopOpeBRepDS_HDataStructure& ChangeDataStructure() ;


Standard_EXPORT  const Handle_TopOpeBRepBuild_HBuilder& Builder() const;


Standard_EXPORT   Handle_TopOpeBRepBuild_HBuilder& ChangeBuilder() ;

//! returns the member myDSA. It is useful to then access <br>
//!          the method GetSectionEdgeSet (wich is a member of DSAccess) <br>
Standard_EXPORT   BRepAlgo_DSAccess& DataStructureAccess() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Performs the global boolean operation. <br>
Standard_EXPORT   void Perform() ;

//! Performs the global boolean operation and build the <br>
//!          result in regards of the given states. <br>
Standard_EXPORT   void Perform(const TopAbs_State State1,const TopAbs_State State2) ;


 // Fields PRIVATE
 //
BRepAlgo_DSAccess myDSA;
TopoDS_Shape myS1;
TopoDS_Shape myS2;
TopoDS_Shape myShape;
TopTools_MapOfShape myMapShape;
TopoDS_Shape myResult;
Standard_Integer myApproxNbPntMax;
Standard_Real myApproxTol3D;
Standard_Real myApproxTol2D;
Standard_Boolean myApproxRelativeTol;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
