// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFeat_SplitShape_HeaderFile
#define _BRepFeat_SplitShape_HeaderFile

#ifndef _LocOpe_Spliter_HeaderFile
#include <LocOpe_Spliter.hxx>
#endif
#ifndef _Handle_LocOpe_WiresOnShape_HeaderFile
#include <Handle_LocOpe_WiresOnShape.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class LocOpe_WiresOnShape;
class StdFail_NotDone;
class Standard_ConstructionError;
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopoDS_Wire;
class TopoDS_Face;
class TopoDS_Edge;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! One of the most significant aspects of BRepFeat functionality is the use of local <br>
//! operations as opposed to global ones. In a global operation, you would first construct a <br>
//! form of the type you wanted in your final feature, and then remove matter so that it could <br>
//! fit into your initial basis object. In a local operation, however, you specify the domain of <br>
//! the feature construction with aspects of the shape on which the feature is being created. <br>
//! These semantics are expressed in terms of a member shape of the basis shape from which - <br>
//! or up to which - matter will be added or removed. As a result, local operations make <br>
//! calculations simpler and faster than global operations. <br>
//! In BRepFeat, the semantics of local operations define features constructed from a contour or a <br>
//! part of the basis shape referred to as the tool. In a SplitShape object, wires or edges of a <br>
//! face in the basis shape to be used as a part of the feature are cut out and projected to a plane <br>
//! outside or inside the basis shape. By rebuilding the initial shape incorporating the edges and <br>
//! the faces of the tool, protrusion or depression features can be constructed. <br>
class BRepFeat_SplitShape  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Empty constructor <br>
BRepFeat_SplitShape();
//! Creates the process  with the shape <S>. <br>
BRepFeat_SplitShape(const TopoDS_Shape& S);
//! Initializes the process on the shape <S>. <br>
  void Init(const TopoDS_Shape& S) ;
//! Adds the wire <W> on the face <F>. <br>
//! Raises NoSuchObject  if <F> does not belong to the original shape. <br>
  void Add(const TopoDS_Wire& W,const TopoDS_Face& F) ;
//! Adds the edge <E> on the face <F>. <br>
  void Add(const TopoDS_Edge& E,const TopoDS_Face& F) ;
//! Adds the edge <E> on the existing edge <EOn>. <br>
  void Add(const TopoDS_Edge& E,const TopoDS_Edge& EOn) ;

//! Returns  the faces   which  are the  left of   the <br>
//!          projected wires. <br>
Standard_EXPORT  const TopTools_ListOfShape& DirectLeft() const;

//! Returns the faces of the "left" part on the shape. <br>
//!          (It  is build   from  DirectLeft,  with  the faces <br>
//!          connected to this set, and so on...). <br>
//! Raises NotDone if IsDone returns <Standard_False>. <br>
Standard_EXPORT  const TopTools_ListOfShape& Left() const;

//! Builds the cut and the resulting faces and edges as well. <br>
Standard_EXPORT   void Build() ;

//! Returns true if the shape has been deleted. <br>
Standard_EXPORT virtual  Standard_Boolean IsDeleted(const TopoDS_Shape& S) ;

//! Returns the list of generated Faces. <br>
Standard_EXPORT  const TopTools_ListOfShape& Modified(const TopoDS_Shape& F) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
LocOpe_Spliter mySShape;
Handle_LocOpe_WiresOnShape myWOnShape;


};


#include <BRepFeat_SplitShape.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
