// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepLib_MakeSolid_HeaderFile
#define _BRepLib_MakeSolid_HeaderFile

#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _BRepLib_MakeShape_HeaderFile
#include <BRepLib_MakeShape.hxx>
#endif
#ifndef _BRepLib_ShapeModification_HeaderFile
#include <BRepLib_ShapeModification.hxx>
#endif
class StdFail_NotDone;
class TopoDS_CompSolid;
class TopoDS_Shell;
class TopoDS_Solid;
class TopoDS_Face;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Makes a solid from compsolid  or  shells. <br>
class BRepLib_MakeSolid  : public BRepLib_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Solid covers whole space. <br>
Standard_EXPORT BRepLib_MakeSolid();

//! Make a solid from a CompSolid. <br>
Standard_EXPORT BRepLib_MakeSolid(const TopoDS_CompSolid& S);

//! Make a solid from a shell. <br>
Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Shell& S);

//! Make a solid from two shells. <br>
Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Shell& S1,const TopoDS_Shell& S2);

//! Make a solid from three shells. <br>
Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Shell& S1,const TopoDS_Shell& S2,const TopoDS_Shell& S3);

//! Make a solid from a solid. Usefull for adding later. <br>
Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Solid& So);

//! Add a shell to a solid. <br>
Standard_EXPORT BRepLib_MakeSolid(const TopoDS_Solid& So,const TopoDS_Shell& S);

//! Add the shell to the current solid. <br>
Standard_EXPORT   void Add(const TopoDS_Shell& S) ;

//! Returns the new Solid. <br>
//! <br>
Standard_EXPORT  const TopoDS_Solid& Solid() const;
Standard_EXPORT operator TopoDS_Solid() const;

//! returns the status of the Face after <br>
//!          the shape creation. <br>
Standard_EXPORT virtual  BRepLib_ShapeModification FaceStatus(const TopoDS_Face& F) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
TopTools_ListOfShape myDeletedFaces;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
