// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepSweep_Rotation_HeaderFile
#define _BRepSweep_Rotation_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _BRepSweep_Trsf_HeaderFile
#include <BRepSweep_Trsf.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class Standard_ConstructionError;
class TopoDS_Shape;
class Sweep_NumShape;
class TopLoc_Location;
class gp_Ax1;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides   an  algorithm   to   build  object   by <br>
//!          Rotation sweep. <br>
class BRepSweep_Rotation  : public BRepSweep_Trsf {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a topology  by rotating <S>  around A with the <br>
//!          angle D. <br>
Standard_EXPORT BRepSweep_Rotation(const TopoDS_Shape& S,const Sweep_NumShape& N,const TopLoc_Location& L,const gp_Ax1& A,const Quantity_PlaneAngle D,const Standard_Boolean C);

//! Builds the vertex addressed by [aGenV,aDirV], with its <br>
//!          geometric part, but without subcomponents. <br>
Standard_EXPORT   TopoDS_Shape MakeEmptyVertex(const TopoDS_Shape& aGenV,const Sweep_NumShape& aDirV) ;

//! Builds the edge addressed by [aGenV,aDirE], with its <br>
//!          geometric part, but without subcomponents. <br>
Standard_EXPORT   TopoDS_Shape MakeEmptyDirectingEdge(const TopoDS_Shape& aGenV,const Sweep_NumShape& aDirE) ;

//! Builds the edge addressed by [aGenE,aDirV], with its <br>
//!          geometric part, but without subcomponents. <br>
Standard_EXPORT   TopoDS_Shape MakeEmptyGeneratingEdge(const TopoDS_Shape& aGenE,const Sweep_NumShape& aDirV) ;

//! Sets the  parameters of the new  vertex  on the new <br>
//!          face. The new face and  new vertex where generated <br>
//!          from aGenF, aGenV and aDirV . <br>
Standard_EXPORT   void SetParameters(const TopoDS_Shape& aNewFace,TopoDS_Shape& aNewVertex,const TopoDS_Shape& aGenF,const TopoDS_Shape& aGenV,const Sweep_NumShape& aDirV) ;

//! Sets the  parameter of the new  vertex  on the new <br>
//!          edge. The new edge and  new vertex where generated <br>
//!          from aGenV aDirE, and aDirV. <br>
Standard_EXPORT   void SetDirectingParameter(const TopoDS_Shape& aNewEdge,TopoDS_Shape& aNewVertex,const TopoDS_Shape& aGenV,const Sweep_NumShape& aDirE,const Sweep_NumShape& aDirV) ;

//! Sets the  parameter of the new  vertex  on the new <br>
//!          edge. The new edge and  new vertex where generated <br>
//!          from aGenE, aGenV and aDirV . <br>
Standard_EXPORT   void SetGeneratingParameter(const TopoDS_Shape& aNewEdge,TopoDS_Shape& aNewVertex,const TopoDS_Shape& aGenE,const TopoDS_Shape& aGenV,const Sweep_NumShape& aDirV) ;

//! Builds the face  addressed by [aGenS,aDirS],  with <br>
//!          its geometric part, but without subcomponents. The <br>
//!          couple aGenS, aDirS can be  a "generating face and <br>
//!          a  directing vertex" or  "a generating  edge and a <br>
//!          directing edge". <br>
Standard_EXPORT   TopoDS_Shape MakeEmptyFace(const TopoDS_Shape& aGenS,const Sweep_NumShape& aDirS) ;

//! Sets the PCurve for a new edge on a new face. The <br>
//!          new edge and  the  new face were generated  using <br>
//!          aGenF, aGenE and aDirV. <br>
Standard_EXPORT   void SetPCurve(const TopoDS_Shape& aNewFace,TopoDS_Shape& aNewEdge,const TopoDS_Shape& aGenF,const TopoDS_Shape& aGenE,const Sweep_NumShape& aDirV,const TopAbs_Orientation orien) ;

//! Sets the PCurve for a new edge on a new face. The <br>
//!          new edge and  the  new face were generated  using <br>
//!          aGenE, aDirE and aDirV. <br>
Standard_EXPORT   void SetGeneratingPCurve(const TopoDS_Shape& aNewFace,TopoDS_Shape& aNewEdge,const TopoDS_Shape& aGenE,const Sweep_NumShape& aDirE,const Sweep_NumShape& aDirV,const TopAbs_Orientation orien) ;

//! Sets the PCurve for a new edge on a new face. The <br>
//!          new edge and  the  new face were generated  using <br>
//!          aGenE, aDirE and aGenV. <br>
Standard_EXPORT   void SetDirectingPCurve(const TopoDS_Shape& aNewFace,TopoDS_Shape& aNewEdge,const TopoDS_Shape& aGenE,const TopoDS_Shape& aGenV,const Sweep_NumShape& aDirE,const TopAbs_Orientation orien) ;

//! Returns the Orientation of the  shell in the solid <br>
//!          generated by the face aGenS  with  the edge aDirS. <br>
//!          It is  REVERSED  if the surface is  swept  in  the <br>
//!          direction of the normal. <br>
Standard_EXPORT   TopAbs_Orientation DirectSolid(const TopoDS_Shape& aGenS,const Sweep_NumShape& aDirS) ;

//! Returns   true   if  aNewSubShape    (addressed by <br>
//!          aSubGenS  and aDirS)  must  be added  in aNewShape <br>
//!          (addressed by aGenS and aDirS). <br>
Standard_EXPORT   Standard_Boolean GGDShapeIsToAdd(const TopoDS_Shape& aNewShape,const TopoDS_Shape& aNewSubShape,const TopoDS_Shape& aGenS,const TopoDS_Shape& aSubGenS,const Sweep_NumShape& aDirS) const;

//! Returns   true   if  aNewSubShape    (addressed by <br>
//!          aGenS  and aSubDirS)  must  be added  in aNewShape <br>
//!          (addressed by aGenS and aDirS). <br>
Standard_EXPORT   Standard_Boolean GDDShapeIsToAdd(const TopoDS_Shape& aNewShape,const TopoDS_Shape& aNewSubShape,const TopoDS_Shape& aGenS,const Sweep_NumShape& aDirS,const Sweep_NumShape& aSubDirS) const;

//! In   some  particular  cases  the  topology  of  a <br>
//!          generated  face  must  be  composed of independant <br>
//!          closed wires, in  this  case this function returns <br>
//!          true.   The  only  case in whitch the function may <br>
//!          return true is a planar face in a closed revol. <br>
Standard_EXPORT   Standard_Boolean SeparatedWires(const TopoDS_Shape& aNewShape,const TopoDS_Shape& aNewSubShape,const TopoDS_Shape& aGenS,const TopoDS_Shape& aSubGenS,const Sweep_NumShape& aDirS) const;

//! In  some  particular  cases  the   topology  of  a <br>
//!          generated  Shell must be  composed  of  independant <br>
//!          closed Shells,  in this case  this function returns <br>
//!          a Compound of independant Shells. <br>
Standard_EXPORT virtual  TopoDS_Shape SplitShell(const TopoDS_Shape& aNewShape) const;

//! Returns true   if aDirS   and aGenS  addresses   a <br>
//!          resulting Shape. In some  specific cases the shape <br>
//!          can  be    geometrically   inexsistant,  then this <br>
//!          function returns false. <br>
Standard_EXPORT   Standard_Boolean HasShape(const TopoDS_Shape& aGenS,const Sweep_NumShape& aDirS) const;

//! Returns true when   the geometry of  aGenS  is not <br>
//!          modified  by the rotation. <br>
Standard_EXPORT   Standard_Boolean IsInvariant(const TopoDS_Shape& aGenS) const;

//! returns the axis <br>
Standard_EXPORT   gp_Ax1 Axe() const;

//! returns the angle. <br>
Standard_EXPORT   Quantity_PlaneAngle Angle() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myAng;
gp_Ax1 myAxe;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
