// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2d_Line_HeaderFile
#define _Geom2d_Line_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom2d_Line_HeaderFile
#include <Handle_Geom2d_Line.hxx>
#endif

#ifndef _gp_Ax2d_HeaderFile
#include <gp_Ax2d.hxx>
#endif
#ifndef _Geom2d_Curve_HeaderFile
#include <Geom2d_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom2d_Geometry_HeaderFile
#include <Handle_Geom2d_Geometry.hxx>
#endif
class Standard_RangeError;
class gp_Ax2d;
class gp_Lin2d;
class gp_Pnt2d;
class gp_Dir2d;
class gp_Vec2d;
class gp_Trsf2d;
class Geom2d_Geometry;


//! Describes an infinite line in the plane (2D space). <br>
//! A line is defined and positioned in the plane with an <br>
//! axis (gp_Ax2d object) which gives it an origin and a unit vector. <br>
//! The Geom2d_Line line is parameterized as follows: <br>
//! P (U) = O + U*Dir <br>
//! where: <br>
//! - P is the point of parameter U, <br>
//! - O is the origin and Dir the unit vector of its positioning axis. <br>
//!   The parameter range is ] -infinite, +infinite [. <br>
//! The orientation of the line is given by the unit vector <br>
//! of its positioning axis. <br>
//! See Also <br>
//! GCE2d_MakeLine which provides functions for more <br>
//! complex line constructions <br>
//! gp_Ax2d <br>
//! gp_Lin2d for an equivalent, non-parameterized data structure. <br>
class Geom2d_Line : public Geom2d_Curve {

public:
 // Methods PUBLIC
 // 


//!  Creates a line located in 2D space with the axis placement A. <br>
//!  The Location of A is the origin of the line. <br>
Standard_EXPORT Geom2d_Line(const gp_Ax2d& A);


//!  Creates a line by conversion of the gp_Lin2d line L. <br>
Standard_EXPORT Geom2d_Line(const gp_Lin2d& L);

//! Constructs a line passing through point P and parallel to <br>
//!   vector V (P and V are, respectively, the origin <br>
//!   and the unit vector of the positioning axis of the line). <br>
Standard_EXPORT Geom2d_Line(const gp_Pnt2d& P,const gp_Dir2d& V);


//!  Set <me> so that <me> has the same geometric properties as L. <br>
Standard_EXPORT   void SetLin2d(const gp_Lin2d& L) ;

//! changes the direction of the line. <br>
Standard_EXPORT   void SetDirection(const gp_Dir2d& V) ;

//! changes the direction of the line. <br>
Standard_EXPORT  const gp_Dir2d& Direction() const;


//!  Changes the "Location" point (origin) of the line. <br>
Standard_EXPORT   void SetLocation(const gp_Pnt2d& P) ;


//!  Changes the "Location" point (origin) of the line. <br>
Standard_EXPORT  const gp_Pnt2d& Location() const;


//!  Changes the "Location" and a the "Direction" of <me>. <br>
Standard_EXPORT   void SetPosition(const gp_Ax2d& A) ;


Standard_EXPORT  const gp_Ax2d& Position() const;


//!  Returns non persistent line from gp with the same geometric <br>
//!  properties as <me> <br>
Standard_EXPORT   gp_Lin2d Lin2d() const;

//! Changes the orientation of this line. As a result, the <br>
//! unit vector of the positioning axis of this line is reversed. <br>
Standard_EXPORT   void Reverse() ;

//! Computes the parameter on the reversed line for the <br>
//! point of parameter U on this line. <br>
//! For a line, the returned value is -U. <br>
Standard_EXPORT   Standard_Real ReversedParameter(const Standard_Real U) const;

//! Returns RealFirst  from  Standard. <br>
Standard_EXPORT   Standard_Real FirstParameter() const;

//! Returns RealLast  from Standard <br>
Standard_EXPORT   Standard_Real LastParameter() const;

//! Returns False <br>
Standard_EXPORT   Standard_Boolean IsClosed() const;

//! Returns False <br>
Standard_EXPORT   Standard_Boolean IsPeriodic() const;

//! Returns GeomAbs_CN, which is the global continuity of any line. <br>
Standard_EXPORT   GeomAbs_Shape Continuity() const;

//! Computes the distance between <me> and the point P. <br>
Standard_EXPORT   Standard_Real Distance(const gp_Pnt2d& P) const;

//! Returns True. <br>
Standard_EXPORT   Standard_Boolean IsCN(const Standard_Integer N) const;

//! Returns in P the point of parameter U. <br>
//!  P (U) = O + U * Dir where O is the "Location" point of the <br>
//!  line and Dir the direction of the line. <br>
Standard_EXPORT   void D0(const Standard_Real U,gp_Pnt2d& P) const;


//!  Returns the point P of parameter u and the first derivative V1. <br>
Standard_EXPORT   void D1(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1) const;


//!  Returns the point P of parameter U, the first and second <br>
//!  derivatives V1 and V2. V2 is a vector with null magnitude <br>
//!  for a line. <br>
Standard_EXPORT   void D2(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2) const;


//!  V2 and V3 are vectors with null magnitude for a line. <br>
Standard_EXPORT   void D3(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2,gp_Vec2d& V3) const;

//! For the point of parameter U of this line, computes <br>
//! the vector corresponding to the Nth derivative. <br>
//! Note: if N is greater than or equal to 2, the result is a <br>
//! vector with null magnitude. <br>
//! Exceptions Standard_RangeError if N is less than 1. <br>
Standard_EXPORT   gp_Vec2d DN(const Standard_Real U,const Standard_Integer N) const;

//! Applies the transformation T to this line. <br>
Standard_EXPORT   void Transform(const gp_Trsf2d& T) ;

//! Computes the parameter on the line transformed by <br>
//! T for the point of parameter U on this line. <br>
//! For a line, the returned value is equal to U multiplied <br>
//! by the scale factor of transformation T. <br>
Standard_EXPORT virtual  Standard_Real TransformedParameter(const Standard_Real U,const gp_Trsf2d& T) const;

//! Returns the coefficient required to compute the <br>
//! parametric transformation of this line when <br>
//! transformation T is applied. This coefficient is the <br>
//! ratio between the parameter of a point on this line <br>
//! and the parameter of the transformed point on the <br>
//! new line transformed by T. <br>
//! For a line, the returned value is the scale factor of the transformation T. <br>
Standard_EXPORT virtual  Standard_Real ParametricTransformation(const gp_Trsf2d& T) const;

//! Creates a new object, which is a copy of this line. <br>
Standard_EXPORT   Handle_Geom2d_Geometry Copy() const;
//Standard_EXPORT ~Geom2d_Line();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Ax2d pos;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
