// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomTools_Curve2dSet_HeaderFile
#define _GeomTools_Curve2dSet_HeaderFile

#ifndef _TColStd_IndexedMapOfTransient_HeaderFile
#include <TColStd_IndexedMapOfTransient.hxx>
#endif
#ifndef _Handle_Message_ProgressIndicator_HeaderFile
#include <Handle_Message_ProgressIndicator.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_IStream_HeaderFile
#include <Standard_IStream.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Message_ProgressIndicator;
class Standard_OutOfRange;
class Geom2d_Curve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Stores a set of Curves from Geom2d. <br>
class GeomTools_Curve2dSet  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns an empty set of Curves. <br>
Standard_EXPORT GeomTools_Curve2dSet();

//! Clears the content of the set. <br>
Standard_EXPORT   void Clear() ;

//! Incorporate a new Curve in the  set and returns <br>
//!          its index. <br>
Standard_EXPORT   Standard_Integer Add(const Handle(Geom2d_Curve)& C) ;

//! Returns the Curve of index <I>. <br>
Standard_EXPORT   Handle_Geom2d_Curve Curve2d(const Standard_Integer I) const;

//! Returns the index of <L>. <br>
Standard_EXPORT   Standard_Integer Index(const Handle(Geom2d_Curve)& C) const;

//! Dumps the content of me on the stream <OS>. <br>
Standard_EXPORT   void Dump(Standard_OStream& OS) const;

//! Writes the content of  me  on the stream <OS> in a <br>
//!          format that can be read back by Read. <br>
Standard_EXPORT   void Write(Standard_OStream& OS) const;

//! Reads the content of me from the  stream  <IS>. me <br>
//!          is first cleared. <br>
//! <br>
Standard_EXPORT   void Read(Standard_IStream& IS) ;

//! Dumps the curve on the stream,  if compact is True <br>
//!          use the compact format that can be read back. <br>
Standard_EXPORT static  void PrintCurve2d(const Handle(Geom2d_Curve)& C,Standard_OStream& OS,const Standard_Boolean compact = Standard_False) ;

//! Reads the curve  from  the stream.  The  curve  is <br>
//!          assumed   to have  been  writtent  with  the Print <br>
//!          method (compact = True). <br>
//! <br>
Standard_EXPORT static  Standard_IStream& ReadCurve2d(Standard_IStream& IS,Handle(Geom2d_Curve)& C) ;


Standard_EXPORT   void SetProgress(const Handle(Message_ProgressIndicator)& PR) ;


Standard_EXPORT   Handle_Message_ProgressIndicator GetProgress() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TColStd_IndexedMapOfTransient myMap;
Handle_Message_ProgressIndicator myProgress;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
