// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_Axis1Placement_HeaderFile
#define _Geom_Axis1Placement_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_Axis1Placement_HeaderFile
#include <Handle_Geom_Axis1Placement.hxx>
#endif

#ifndef _Geom_AxisPlacement_HeaderFile
#include <Geom_AxisPlacement.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class gp_Ax1;
class gp_Pnt;
class gp_Dir;
class gp_Trsf;
class Geom_Geometry;


//! Describes an axis in 3D space. <br>
//! An axis is defined by: <br>
//! - its origin, also termed the "Location point" of the axis, <br>
//! - its unit vector, termed the "Direction" of the axis. <br>
//! Note: Geom_Axis1Placement axes provide the <br>
//! same kind of "geometric" services as gp_Ax1 axes <br>
//! but have more complex data structures. The <br>
//! geometric objects provided by the Geom package <br>
//! use gp_Ax1 objects to include axes in their data <br>
//! structures, or to define an axis of symmetry or axis of rotation. <br>
//! Geom_Axis1Placement axes are used in a context <br>
//! where they can be shared by several objects <br>
//! contained inside a common data structure. <br>
class Geom_Axis1Placement : public Geom_AxisPlacement {

public:
 // Methods PUBLIC
 // 

//! Returns a transient copy of A1. <br>
Standard_EXPORT Geom_Axis1Placement(const gp_Ax1& A1);


//!  P is the origin of the axis placement and V is the direction <br>
//!  of the axis placement. <br>
Standard_EXPORT Geom_Axis1Placement(const gp_Pnt& P,const gp_Dir& V);

//! Returns a non transient copy of <me>. <br>
Standard_EXPORT  const gp_Ax1& Ax1() const;

//! Reverses the direction of the axis placement. <br>
Standard_EXPORT   void Reverse() ;

//!  Returns a copy of <me> reversed. <br>
Standard_EXPORT   Handle_Geom_Axis1Placement Reversed() const;

//! Assigns V to the unit vector of this axis. <br>
Standard_EXPORT   void SetDirection(const gp_Dir& V) ;

//! Applies the transformation T to this axis. <br>
Standard_EXPORT   void Transform(const gp_Trsf& T) ;

//! Creates a new object, which is a copy of this axis. <br>
Standard_EXPORT   Handle_Geom_Geometry Copy() const;
//Standard_EXPORT ~Geom_Axis1Placement();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
