// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Image_PseudoColorImage_HeaderFile
#define _Image_PseudoColorImage_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Image_PseudoColorImage_HeaderFile
#include <Handle_Image_PseudoColorImage.hxx>
#endif

#ifndef _Handle_Aspect_ColorMap_HeaderFile
#include <Handle_Aspect_ColorMap.hxx>
#endif
#ifndef _Image_DIndexedImage_HeaderFile
#include <Image_DIndexedImage.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Image_TypeOfImage_HeaderFile
#include <Image_TypeOfImage.hxx>
#endif
#ifndef _Handle_Quantity_HArray1OfColor_HeaderFile
#include <Handle_Quantity_HArray1OfColor.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Image_Image_HeaderFile
#include <Handle_Image_Image.hxx>
#endif
class Aspect_ColorMap;
class Aspect_IndexPixel;
class Quantity_Color;
class Quantity_HArray1OfColor;
class Quantity_Array1OfColor;
class Image_LookupTable;
class Image_Image;


//! A PseudoColorImage is a DIndexedImage associated with a <br>
//!	     ColorMap . The ColoMap is set at Creation time and then <br>
//!	     never be changed. Each Pixel in the Image ,as a IndexPixel <br>
//!	     from Aspect, match a ColoMap Entry with the same value. <br>
class Image_PseudoColorImage : public Image_DIndexedImage {

public:
 // Methods PUBLIC
 // 

//! Creates a PseudoColorImage object. <br>
//!	       The default Background Pixel is set to 0 . <br>
//!	       All the Image is initialised with Background Pixel <br>
Standard_EXPORT Image_PseudoColorImage(const Standard_Integer x,const Standard_Integer y,const Standard_Integer dx,const Standard_Integer dy,const Handle(Aspect_ColorMap)& aColorMap);

//! Creates a PseudoColorImage object and set the <br>
//!	       Background Pixel. <br>
//!	       All the Image is initialised with Background Pixel <br>
Standard_EXPORT Image_PseudoColorImage(const Standard_Integer x,const Standard_Integer y,const Standard_Integer dx,const Standard_Integer dy,const Handle(Aspect_ColorMap)& aColorMap,const Aspect_IndexPixel& BackPixel);

//! Returns the Image Type. <br>
Standard_EXPORT   Image_TypeOfImage Type() const;

//! returns the Image ColorMap . <br>
Standard_EXPORT   Handle_Aspect_ColorMap ColorMap() const;

//! Returns the Pixel Color . <br>
Standard_EXPORT  const Quantity_Color& PixelColor(const Standard_Integer X,const Standard_Integer Y) const;

//! Return the PixelRow Color in a HArray1 of Color. <br>
Standard_EXPORT virtual  Handle_Quantity_HArray1OfColor RowColor(const Standard_Integer Y) const;

//! Stores the PixelRow Color in a Array1 . <br>
Standard_EXPORT virtual  void RowColor(const Standard_Integer Y,Quantity_Array1OfColor& aArray1) const;

//! Creates a new Image with continuous Pixel and a continuous <br>
//!              ColorMap whith only used Image color starting from <br>
//!		BasePixel . <br>
Standard_EXPORT   Handle_Image_PseudoColorImage Squeeze(const Aspect_IndexPixel& BasePixel) const;

//! Creates a LookupTable that can be used to create a <br>
//!	    new Image with continuous Pixel and a continuous <br>
//!	    ColorMap with only used Image color starting <br>
//!	    from BasePixel . <br>
Standard_EXPORT   void SqueezedLookupTable(const Aspect_IndexPixel& BasePixel,Image_LookupTable& aLookup) const;

//! Pass a PseudoColorImage through a lookupTable <br>
Standard_EXPORT   void Lookup(const Image_LookupTable& aLookup) ;

//! Find the maximum and minimum Pixel Value of an Image. <br>
Standard_EXPORT   void Extrema(Aspect_IndexPixel& Min,Aspect_IndexPixel& Max) const;

//! This method changes the value of any Pixel beetwen the <br>
//!	    range (Min->Max) to the Pixel Map value. All Pixel values <br>
//!	    outside the range are passed through without changed . <br>
Standard_EXPORT   void Threshold(const Aspect_IndexPixel& Min,const Aspect_IndexPixel& Max,const Aspect_IndexPixel& Map) ;

//! Map the Image Pixel Value from one range to another range. <br>
//!	     This method perform the mapping by multiplying each <br>
//!	     Pixel Value by Scale and then adding Offset to the result. <br>
Standard_EXPORT   void Rescale(const Standard_Real Scale,const Standard_Real Offset) ;

//! Duplicate a Image. <br>
Standard_EXPORT   Handle_Image_Image Dup() const;
//Standard_EXPORT ~Image_PseudoColorImage();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Aspect_ColorMap myColorMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
