// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntCurve_IConicTool_HeaderFile
#define _IntCurve_IConicTool_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Ax22d_HeaderFile
#include <gp_Ax22d.hxx>
#endif
#ifndef _GeomAbs_CurveType_HeaderFile
#include <GeomAbs_CurveType.hxx>
#endif
#ifndef _gp_Trsf2d_HeaderFile
#include <gp_Trsf2d.hxx>
#endif
class gp_Elips2d;
class gp_Lin2d;
class gp_Circ2d;
class gp_Parab2d;
class gp_Hypr2d;
class gp_Pnt2d;
class gp_Vec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Implementation of the ImpTool from IntImpParGen <br>
//!          for conics of gp. <br>
class IntCurve_IConicTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT IntCurve_IConicTool();


Standard_EXPORT IntCurve_IConicTool(const IntCurve_IConicTool& IT);


Standard_EXPORT IntCurve_IConicTool(const gp_Elips2d& E);


Standard_EXPORT IntCurve_IConicTool(const gp_Lin2d& L);


Standard_EXPORT IntCurve_IConicTool(const gp_Circ2d& C);


Standard_EXPORT IntCurve_IConicTool(const gp_Parab2d& P);


Standard_EXPORT IntCurve_IConicTool(const gp_Hypr2d& H);


Standard_EXPORT   gp_Pnt2d Value(const Standard_Real X) const;


Standard_EXPORT   void D1(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& T) const;


Standard_EXPORT   void D2(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& T,gp_Vec2d& N) const;

//! Computes the value of the signed  distance between <br>
//!          the point P and the implicit curve. <br>
Standard_EXPORT   Standard_Real Distance(const gp_Pnt2d& P) const;

//! Computes  the   Gradient  of  the  Signed Distance <br>
//!          between  a  point and  the  implicit curve, at the <br>
//!          point P. <br>
Standard_EXPORT   gp_Vec2d GradDistance(const gp_Pnt2d& P) const;

//! Returns the   parameter  U of   the point  on  the <br>
//!          implicit curve corresponding to  the point P.  The <br>
//!          correspondance between P and the point P(U) on the <br>
//!          implicit curve must be coherent  with the  way  of <br>
//!          determination of the signed distance. <br>
Standard_EXPORT   Standard_Real FindParameter(const gp_Pnt2d& P) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real prm1;
Standard_Real prm2;
Standard_Real prm3;
gp_Ax22d Axis;
GeomAbs_CurveType type;
gp_Trsf2d Abs_To_Object;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
