// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntSurf_InteriorPointTool_HeaderFile
#define _IntSurf_InteriorPointTool_HeaderFile

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _gp_Dir2d_HeaderFile
#include <gp_Dir2d.hxx>
#endif
class IntSurf_InteriorPoint;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides a tool on the "interior point" <br>
//!          that can be used to instantiates the Walking <br>
//!          algorithmes (see package IntWalk). <br>
class IntSurf_InteriorPointTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Returns the 3d coordinates of the starting point. <br>
static  gp_Pnt Value3d(const IntSurf_InteriorPoint& PStart) ;
//! Returns the <U,V> parameters which are associated <br>
//!          with <P> <br>
//!          it's the parameters which start the marching algorithm <br>
static  void Value2d(const IntSurf_InteriorPoint& PStart,Standard_Real& U,Standard_Real& V) ;
//! returns the tangent at the intersectin in 3d space <br>
//!          associated to <P> <br>
static  gp_Vec Direction3d(const IntSurf_InteriorPoint& PStart) ;
//! returns the tangent at the intersectin in the <br>
//!          parametric space of the parametrized surface.This tangent <br>
//!          is associated to the value2d <br>
static  gp_Dir2d Direction2d(const IntSurf_InteriorPoint& PStart) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <IntSurf_InteriorPointTool.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
