// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ProjLib_PrjResolve_HeaderFile
#define _ProjLib_PrjResolve_HeaderFile

#ifndef _Adaptor3d_CurvePtr_HeaderFile
#include <Adaptor3d_CurvePtr.hxx>
#endif
#ifndef _Adaptor3d_SurfacePtr_HeaderFile
#include <Adaptor3d_SurfacePtr.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class Standard_ConstructionError;
class StdFail_NotDone;
class Adaptor3d_Curve;
class Adaptor3d_Surface;
class gp_Pnt2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class ProjLib_PrjResolve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT ProjLib_PrjResolve(const Adaptor3d_Curve& C,const Adaptor3d_Surface& S,const Standard_Integer Fix);

//! Calculates the ort from  C(t)  to  S  with a close point. <br>
//!          The close point is defined by the parameter values <br>
//!          U0 and V0. <br>
//!          The function F(u,v)=distance(S(u,v),C(t)) has an <br>
//!          extremum when gradient(F)=0. The algorithm searchs <br>
//!          a zero near the close point. <br>
Standard_EXPORT   void Perform(const Standard_Real t,const Standard_Real U,const Standard_Real V,const gp_Pnt2d& Tol,const gp_Pnt2d& Inf,const gp_Pnt2d& Sup,const Standard_Real FTol = -1,const Standard_Boolean StrictInside = Standard_False) ;

//! Returns True if the distance is found. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;

//! Returns the point of the extremum distance. <br>
Standard_EXPORT   gp_Pnt2d Solution() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Adaptor3d_CurvePtr myCurve;
Adaptor3d_SurfacePtr mySurface;
Standard_Boolean myDone;
gp_Pnt2d mySolution;
Standard_Integer myFix;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
