// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDF_ClosureMode_HeaderFile
#define _TDF_ClosureMode_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides options closure management. <br>
class TDF_ClosureMode  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an objet with all modes set to <aMode>. <br>
Standard_EXPORT TDF_ClosureMode(const Standard_Boolean aMode = Standard_True);
//! Sets the mode "Descendants" to <aStatus>. <br>
//! <br>
//!          "Descendants" mode means we add to the data set <br>
//!          the children labels of each USER GIVEN label. We <br>
//!          do not do that with the labels found applying <br>
//!          UpToFirstLevel option. <br>
//! <br>
  void Descendants(const Standard_Boolean aStatus) ;
//! Returns true if the mode "Descendants" is set. <br>
//! <br>
  Standard_Boolean Descendants() const;
//! Sets the mode "References" to <aStatus>. <br>
//! <br>
//!          "References" mode means we add to the data set <br>
//!          the descendants of an attribute, by calling the <br>
//!          attribute method Descendants(). <br>
//! <br>
  void References(const Standard_Boolean aStatus) ;
//! Returns true if the mode "References" is set. <br>
//! <br>
  Standard_Boolean References() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myFlags;


};


#include <TDF_ClosureMode.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
