// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDocStd_MultiTransactionManager_HeaderFile
#define _TDocStd_MultiTransactionManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDocStd_MultiTransactionManager_HeaderFile
#include <Handle_TDocStd_MultiTransactionManager.hxx>
#endif

#ifndef _TDocStd_SequenceOfDocument_HeaderFile
#include <TDocStd_SequenceOfDocument.hxx>
#endif
#ifndef _TDocStd_SequenceOfApplicationDelta_HeaderFile
#include <TDocStd_SequenceOfApplicationDelta.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Handle_TDocStd_Document_HeaderFile
#include <Handle_TDocStd_Document.hxx>
#endif
class TDocStd_SequenceOfApplicationDelta;
class TCollection_ExtendedString;
class TDocStd_Document;
class TDocStd_SequenceOfDocument;


//! Class for synchronization of transactions within multiple documents. <br>
//!          Each transaction of this class involvess one transaction in each modified document. <br>
class TDocStd_MultiTransactionManager : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Constructor <br>
Standard_EXPORT TDocStd_MultiTransactionManager();

//! Sets undo limit for the manager and all documents. <br>
Standard_EXPORT   void SetUndoLimit(const Standard_Integer theLimit) ;
//! Returns undo limit for the manager. <br>
  Standard_Integer GetUndoLimit() const;

//! Undoes the current transaction of the manager. <br>
//!          It calls the Undo () method of the document being <br>
//!          on top of the manager list of undos (list.First()) <br>
//!          and moves the list item to the top of the list of manager <br>
//!          redos (list.Prepend(item)). <br>
Standard_EXPORT   void Undo() ;

//! Redoes the current transaction of the application. It calls <br>
//!          the Redo () method of the document being on top of the <br>
//!          manager list of redos (list.First()) and moves the list <br>
//!          item to the top of the list of manager undos (list.Prepend(item)). <br>
Standard_EXPORT   void Redo() ;
//! Returns available manager undos. <br>
 const TDocStd_SequenceOfApplicationDelta& GetAvailableUndos() const;
//! Returns available manager redos. <br>
 const TDocStd_SequenceOfApplicationDelta& GetAvailableRedos() const;

//! Opens transaction in each document and sets the flag that <br>
//!          transaction is opened. If there are already opened transactions in the documents, <br>
//!          these transactions will be aborted before openning new ones. <br>
Standard_EXPORT   void OpenCommand() ;

//! Unsets the flag of started manager transaction and aborts <br>
//!          transaction in each document. <br>
Standard_EXPORT   void AbortCommand() ;

//! Commits transaction in all documents and fills the transaction manager <br>
//!          with the documents that have been changed during the transaction. <br>
//!          Returns True if new data has been added to myUndos. <br>
//!          NOTE: All nested transactions in the documents will be commited. <br>
Standard_EXPORT   Standard_Boolean CommitCommand() ;

//! Makes the same steps as the previous function but defines the name for transaction. <br>
//!          Returns True if new data has been added to myUndos. <br>
Standard_EXPORT   Standard_Boolean CommitCommand(const TCollection_ExtendedString& theName) ;
//! Returns true if a transaction is opened. <br>
  Standard_Boolean HasOpenCommand() const;

//! Removes undo information from the list of undos of the manager and <br>
//!          all documents which have been modified during the transaction. <br>
Standard_EXPORT   void RemoveLastUndo() ;

//! Dumps transactions in undos and redos <br>
Standard_EXPORT   void DumpTransaction(Standard_OStream& theOS) const;

//! Adds the document to the transaction manager and <br>
//!          checks if it has been already added <br>
Standard_EXPORT   void AddDocument(const Handle(TDocStd_Document)& theDoc) ;

//! Removes the document from the transaction manager. <br>
Standard_EXPORT   void RemoveDocument(const Handle(TDocStd_Document)& theDoc) ;
//! Returns the added documents to the transaction manager. <br>
 const TDocStd_SequenceOfDocument& Documents() const;

//! Sets nested transaction mode if isAllowed == Standard_True <br>
//!          NOTE: field myIsNestedTransactionMode exists only for synchronization <br>
//!           between several documents and has no effect on transactions <br>
//!          of multitransaction manager. <br>
Standard_EXPORT   void SetNestedTransactionMode(const Standard_Boolean isAllowed = Standard_True) ;
//! Returns Standard_True if NestedTransaction mode is set. <br>//! Methods for protection of changes outside transactions <br>
  Standard_Boolean IsNestedTransactionMode() const;

//! If theTransactionOnly is True, denies all changes outside transactions. <br>
Standard_EXPORT   void SetModificationMode(const Standard_Boolean theTransactionOnly) ;
//! Returns True if changes are allowed only inside transactions. <br>
  Standard_Boolean ModificationMode() const;

//! Clears undos in the manager and in documents. <br>
Standard_EXPORT   void ClearUndos() ;

//! Clears redos in the manager and in documents. <br>
Standard_EXPORT   void ClearRedos() ;
//Standard_EXPORT ~TDocStd_MultiTransactionManager();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TDocStd_SequenceOfDocument myDocuments;
TDocStd_SequenceOfApplicationDelta myUndos;
TDocStd_SequenceOfApplicationDelta myRedos;
Standard_Integer myUndoLimit;
Standard_Boolean myOpenTransaction;
Standard_Boolean myIsNestedTransactionMode;
Standard_Boolean myOnlyTransactionModification;


};


#include <TDocStd_MultiTransactionManager.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
