// File:	BRepMesh_Vertex.cxx
// Created:	Thu Sep 23 12:46:51 1993
// Author:	Didier PIFFAULT
//		<dpf@zerox>

#include <BRepMesh_Vertex.ixx>
#include <Precision.hxx>


BRepMesh_Vertex::BRepMesh_Vertex()
     : myDomain(0), myLocation(0), myMovability(MeshDS_Free)
{}

BRepMesh_Vertex::BRepMesh_Vertex(const gp_XY& UV,
				 const Standard_Integer Dom,
				 const Standard_Integer Locat3d,
				 const MeshDS_DegreeOfFreedom Move)
     : myUV(UV), myDomain(Dom), myLocation(Locat3d), myMovability(Move)
{}

BRepMesh_Vertex::BRepMesh_Vertex(const Standard_Real U,
				 const Standard_Real V,
				 const Standard_Integer Dom,
				 const MeshDS_DegreeOfFreedom Move)
     : myUV(U, V), myDomain(Dom), myLocation(0), myMovability(Move)
{}

void  BRepMesh_Vertex::Initialize(const gp_XY& UV,
				  const Standard_Integer Dom,
				  const Standard_Integer Locat3d,
				  const MeshDS_DegreeOfFreedom Move)
{
  myUV=UV;
  myDomain=Dom;
  myLocation=Locat3d;
  myMovability=Move;
}

void  BRepMesh_Vertex::SetMovability(const MeshDS_DegreeOfFreedom Move)
{
  myMovability=Move;
}

//=======================================================================
//function : HashCode IsEqual 
//purpose  : Services for Map
//=======================================================================
Standard_Integer  BRepMesh_Vertex::HashCode(const Standard_Integer Upper)const
{
  // 20/02/02 akm (OCC179) return ::HashCode(myDomain*myLocation, Upper);
  return ::HashCode (Floor(1e5*myUV.X())*Floor(1e5*myUV.Y()), Upper);
}

Standard_Boolean  BRepMesh_Vertex::IsEqual(const BRepMesh_Vertex& Other)const
{
  if (myMovability!=MeshDS_Deleted && Other.myMovability!=MeshDS_Deleted &&
      myDomain==Other.myDomain) // 20/02/02 akm && myLocation==Other.myLocation)
    return (myUV.IsEqual(Other.myUV, Precision::PConfusion()));
  return Standard_False;
}

