/***********************************************************************

     FONCTION :
     ----------
        File OpenGl_cmn_htbl.c :
 

     REMARQUES:
     ---------- 
      

     HISTORIQUE DES MODIFICATIONS   :
     --------------------------------
       xx-xx-xx : xxx ; Creation.
       05-01-98 : FMN ; Suppression WNT inutile
       07-12-98 : CAL ; PRO 16311 et PRO 11821
       14.07.06 : SAN : OCC12977 : cmn_get_from_htbl() added, can be used to obtain
                        the 1st element in a hash-table (prev == 0) or 
                        for iteration through it (prev points to the previous element in the table)

************************************************************************/

/*----------------------------------------------------------------------*/
/*
 * Includes
 */

#include <OpenGl_tgl_all.h>
#include <OpenGl_cmn_memory.h>
#include <OpenGl_cmn_stg_tbl.h>
#include <OpenGl_cmn_htbl.h>

static cmn_stg_tbl cmn_htbl_elem_block;

static Tint
find_in_htbl( cmn_htbl  h, Tint  w,
              cmn_htbl_elem  *e, cmn_htbl_elem *p,
              cmn_htbl_elem *n )
{
   unsigned int i ;
   int f ;
   register cmn_htbl_elem  q ;

   i = (Tint)w ;  /* careful */
   CMN_HASH( i , h -> size ) ;

   i++ ;
   f = -(int)i ;

   q = h -> ptr[ i ] ;

   *p = (cmn_htbl_elem)( &(h -> ptr[ i ]) ) ;
   *n = (cmn_htbl_elem)0 ;

   while( q )
   {
      if( q -> token == w ) /* found in overflow list */
      {
         f     = i ;
         *n    = q -> next ;
         break ;
      }
     *p = q ;
      q = q -> next ;
   }

   *e = q ;
   return( f ) ;
}

cmn_htbl
cmn_create_htbl( Tint  size )
{
    register  Tint  i;
    register  cmn_htbl   htbl ;

    if( size < 1 )
        return 0;

    i = size ;
    /* les <size> elements sont dans le tableau ptr de [0..size] */
    size++   ;
    size += sizeof(Tint) ; /* Tint size */
    /* on est aligne sur des mots de 64 bits pour les machines 64 bits */
    size += sizeof(Tint) ; /* PRO 16311 et PRO 11821 Tint foo */
    size *= sizeof( cmn_htbl_elem ) ; /* cmn_htbl_elem ptr[1] */

    htbl = (cmn_htbl)cmn_getmem( 1 , size , 1 ) ;
    if ( htbl == 0 )
        return 0;

    htbl -> size = i ;
    htbl -> foo = i ;
    return htbl;
}


cmn_htbl_elem
cmn_add_in_htbl( cmn_htbl  h, Tint  w, void *data )
{
   register Tint  i;
   register cmn_htbl_elem  q ;
            cmn_htbl_elem  e ;
            cmn_htbl_elem  p ; /* dummy not used */

   i = find_in_htbl( h , w , &e , &p , &p ) ;
   q = e ;
   if( i < 0L ) /* not found so add in tbl */
   {
       i = ( -i ) ;

       if ( cmn_htbl_elem_block == 0 )
       {
          cmn_htbl_elem_block = cmn_stg_tbl_create(
                                            CMN_HASH_ELEM_TBL_SIZE       ,
                                            sizeof( CMN_HTBL_ELEM ) ) ;
          if ( cmn_htbl_elem_block == 0 )
             return 0;
       }
       q = cmn_stg_tbl_get( cmn_htbl_elem_block ) ;
       if( q == 0 )
             return 0;

       q -> next     = h -> ptr[ i ] ;
       h -> ptr[ i ] = q ;

       q -> token   = w ;
   }

   q -> data  = data  ;

   return q;
}

cmn_htbl_elem
cmn_find_in_htbl( cmn_htbl  h, Tint  w, void **data )
{
   register Tint i;
   register cmn_htbl_elem  q ;
            cmn_htbl_elem  e ;
            cmn_htbl_elem  p ; /* dummy not used */

   i = find_in_htbl( h , w , &e , &p , &p ) ;
   q = e ;
   if( i > 0L ) /* found in tbl */
   {
       *data  = q -> data  ;
   }
   return q;
}


TStatus
cmn_delete_from_htbl( cmn_htbl  h, Tint  w, void **data )
{
   register Tint i;
   register cmn_htbl_elem  q ;
            cmn_htbl_elem  e ;
            cmn_htbl_elem  p ; /* priv */
            cmn_htbl_elem  n ; /* next */

   i = find_in_htbl( h , w , &e , &p , &n ) ;
   q = e ;
   if( i > 0L ) /* found in tbl */
   {
       *data  = q -> data  ;
       p -> next = n ;
       cmn_stg_tbl_free( q );
       return TSuccess;
   }
   return TFailure;
}

cmn_htbl_elem   
cmn_get_from_htbl( cmn_htbl h, Tint* w, void** data, cmn_htbl_elem prev)
{
   cmn_htbl_elem q = 0;
   Tint i;

   *w = -1;
   *data = 0;

   if ( prev )
   {
      q = prev->next;
   }
   else
   {
     for ( i = 0; !q && i < h->size; i++ )
        q = h->ptr[i];
   }

   if ( q )
   {
     *w = q->token;
     *data = q->data;
   }

   return q;
}
