// File:	StepToGeom_MakeRectangularTrimmedSurface.cxx
// Created:	Thu Jan 25 12:01:33 1996
// Author:	Frederic MAUPAS
//		<fma@pronox>

#include <StepToGeom_MakeRectangularTrimmedSurface.ixx>

#include <StepToGeom_MakeSurface.hxx>
#include <StdFail_NotDone.hxx>

#include <Geom_CylindricalSurface.hxx>
#include <Geom_ConicalSurface.hxx>
#include <Geom_ToroidalSurface.hxx>
#include <Geom_SphericalSurface.hxx>
#include <Geom_SurfaceOfRevolution.hxx>
#include <Geom_Plane.hxx>

#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' une RectangularTrimmedSurface de Geom a partir d' une
// RectangularTrimmedSurface de Step
//=============================================================================

StepToGeom_MakeRectangularTrimmedSurface::StepToGeom_MakeRectangularTrimmedSurface
  ( const Handle(StepGeom_RectangularTrimmedSurface)& S)
{
  Standard_Real U1,U2,V1,V2;
  Standard_Boolean SameUSense, SameVSense;
  
  U1 = S->U1();
  U2 = S->U2();
  V1 = S->V1();
  V2 = S->V2();
  SameUSense = S->Usense();
  SameVSense = S->Vsense();
  
  StepToGeom_MakeSurface MkSurf(S->BasisSurface());

  Handle(Geom_Surface) theBasis = MkSurf.Value();

  // -----------------------------------------
  // Modification of the Trimming Parameters ?
  // -----------------------------------------
  
//  Standard_Real Fact = PI/180.;
  Standard_Real uFact       = 1.;
  Standard_Real vFact       = 1.; 
  Standard_Real LengthFact  = UnitsMethods::LengthFactor();
  Standard_Real AngleFact   = UnitsMethods::PlaneAngleFactor(); // abv 30.06.00 trj4_k1_geo-tc-214.stp #1477: PI/180.;

  if (theBasis->IsKind(STANDARD_TYPE(Geom_SphericalSurface)) ||
      theBasis->IsKind(STANDARD_TYPE(Geom_ToroidalSurface))) {
    uFact = vFact = AngleFact;
  }
  else if (theBasis->IsKind(STANDARD_TYPE(Geom_CylindricalSurface))) {
    uFact = AngleFact;
    vFact = LengthFact;
  }
  else if ( theBasis->IsKind(STANDARD_TYPE(Geom_SurfaceOfRevolution))) {
    uFact = AngleFact;
  }
  else if (theBasis->IsKind(STANDARD_TYPE(Geom_ConicalSurface))) {
    Handle(Geom_ConicalSurface) conicS = 
      Handle(Geom_ConicalSurface)::DownCast(theBasis);
    Standard_Real semAng = conicS->SemiAngle();
    uFact = AngleFact;
    vFact = LengthFact / Cos(semAng);
  }
  else if (theBasis->IsKind(STANDARD_TYPE(Geom_Plane))) {
    uFact = vFact = LengthFact;
  }
  
  U1 = U1 * uFact;
  U2 = U2 * uFact;
  V1 = V1 * vFact;
  V2 = V2 * vFact;

  theRectangularTrimmedSurface = 
    new Geom_RectangularTrimmedSurface(theBasis, U1, U2, V1, V2, 
				       SameUSense, SameVSense);
  done = Standard_True;
}


//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_RectangularTrimmedSurface) &
      StepToGeom_MakeRectangularTrimmedSurface::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theRectangularTrimmedSurface;
}
