// File:	StepToGeom_MakeSphericalSurface.cxx
// Created:	Fri Jul  2 18:35:52 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakeSphericalSurface.ixx>
#include <StepGeom_SphericalSurface.hxx>
#include <Geom_SphericalSurface.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <Geom_Axis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' une SphericalSurface de Geom a partir d' une 
// SphericalSurface de Step
//=============================================================================

StepToGeom_MakeSphericalSurface::StepToGeom_MakeSphericalSurface
  ( const Handle(StepGeom_SphericalSurface)& S)
{
  Standard_Real R;
  Handle(StepGeom_Axis2Placement3d) A;
  Handle(Geom_Axis2Placement)           A1;
  gp_Ax2                                A2;

  R   = S->Radius() * UnitsMethods::LengthFactor();
  A   = S->Position();
  StepToGeom_MakeAxis2Placement MkAxis2(A);
  A1  = MkAxis2.Value();
  A2  = A1->Ax2();
  theSphericalSurface = new Geom_SphericalSurface(A2, R);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_SphericalSurface) &
      StepToGeom_MakeSphericalSurface::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theSphericalSurface;
}
