// File:	StepToGeom_MakeTransformation3d.cxx
// Created:	Tue Feb 16 11:18:48 1999
// Author:	Andrey BETENEV
//		<abv@doomox.nnov.matra-dtv.fr>
// sln 23.10.2001. CTS23496: If problems with creation of direction occur default direction is used (StepToGeom_MakeTransformation2d(...) function)

#include <StepToGeom_MakeTransformation2d.ixx>
#include <StepToGeom_MakeCartesianPoint2d.hxx>
#include <StepToGeom_MakeDirection2d.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepGeom_Direction.hxx>
#include <Geom2d_CartesianPoint.hxx>
#include <Geom2d_Direction.hxx>
#include <gp_Ax2d.hxx>

//=======================================================================
//function : StepToGeom_MakeTransformation2d
//purpose  : 
//=======================================================================

StepToGeom_MakeTransformation2d::StepToGeom_MakeTransformation2d (const Handle(StepGeom_CartesianTransformationOperator2d) &CTO ) 
{
//  NB : on ne s interesse ici qu au deplacement rigide
  Handle(StepGeom_CartesianPoint) P = CTO->LocalOrigin();
  Handle(StepGeom_Direction) A1 = CTO->Axis1();

  StepToGeom_MakeCartesianPoint2d MkPoint(P);
  gp_Pnt2d Pgp = MkPoint.Value()->Pnt2d();

  gp_Dir2d D1;
  // sln 23.10.2001. CTS23496: If problems with creation of direction occur default direction is used
  Standard_Boolean isDefaultDirectionUsed = Standard_True;
  if (!A1.IsNull()) {
    StepToGeom_MakeDirection2d M1(A1);
    if(M1.IsDone()) {
      D1 = M1.Value()->Dir2d();
      isDefaultDirectionUsed = Standard_False;
    }
  }
  if(isDefaultDirectionUsed) 
    D1 = gp_Dir2d (1.,0.);

  gp_Ax2d result (Pgp,D1);
  myT.SetTransformation(result);
  myT = myT.Inverted();
  
  done = Standard_True;
}

//=======================================================================
//function : Value
//purpose  : 
//=======================================================================

const gp_Trsf2d &StepToGeom_MakeTransformation2d::Value () const
{
  return myT;
}
