// File:	TDataStd_Plane.cxx
// Created:	Thu Mar  6 10:29:53 1997
// Author:	Denis PASCAL


#include <TDataStd_Plane.ixx>
#include <TDataStd.hxx>
#include <TNaming_NamedShape.hxx>
#include <TNaming_Tool.hxx>
#include <TNaming_Builder.hxx>
#include <TDF_Label.hxx>
#include <gp_Pln.hxx>
#include <TopoDS.hxx>
#include <TopoDS_Face.hxx>
#include <TopAbs.hxx>
#include <BRep_Tool.hxx>
#include <BRepBuilderAPI_MakeFace.hxx>
#include <Geom_RectangularTrimmedSurface.hxx>
#include <Geom_Plane.hxx>
#include <GeomLib_IsPlanarSurface.hxx>

#define OCC2932

//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Plane::GetID () 
{
  static Standard_GUID TDataStd_PlaneID("2a96b60c-ec8b-11d0-bee7-080009dc3333");
  return TDataStd_PlaneID;
}

 
//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_Plane) TDataStd_Plane::Set (const TDF_Label& L)
{
  Handle(TDataStd_Plane) A;
  if (!L.FindAttribute(TDataStd_Plane::GetID(),A)) {
    A = new TDataStd_Plane (); 
    L.AddAttribute(A);
  }  
  return A;
}



//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_Plane) TDataStd_Plane::Set (const TDF_Label& L, const gp_Pln& P)
{ 
  Handle(TDataStd_Plane) A = Set (L);

#ifdef OCC2932
  Handle(TNaming_NamedShape) aNS;
  if(L.FindAttribute(TNaming_NamedShape::GetID(), aNS)) {
    if(!aNS->Get().IsNull())
       if(aNS->Get().ShapeType() == TopAbs_FACE) {
	 TopoDS_Face aFace = TopoDS::Face(aNS->Get());
	 Handle(Geom_Surface) aSurface = BRep_Tool::Surface(aFace);
	 GeomLib_IsPlanarSurface aChecker(aSurface);
	 if(aChecker.IsPlanar()) {
	   gp_Pln aPlane = aChecker.Plan();
	   if(aPlane.Location().X() == P.Location().X() &&
	      aPlane.Location().Y() == P.Location().Y() &&
	      aPlane.Location().Z() == P.Location().Z() &&
	      aPlane.Axis().Location().X() == P.Axis().Location().X() &&
	      aPlane.Axis().Location().Y() == P.Axis().Location().Y() &&
	      aPlane.Axis().Location().Z() == P.Axis().Location().Z() &&
	      aPlane.Axis().Direction().X() == P.Axis().Direction().X() &&
	      aPlane.Axis().Direction().Y() == P.Axis().Direction().Y() &&
	      aPlane.Axis().Direction().Z() == P.Axis().Direction().Z()
	      )
	     return A;
	 }
       }
  }
#endif

  TNaming_Builder B(L);
  B.Generated(BRepBuilderAPI_MakeFace(P));
  return A;
}

//=======================================================================
//function : TDataStd_Plane
//purpose  : 
//=======================================================================

TDataStd_Plane::TDataStd_Plane () { }


//=======================================================================
//function : ID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Plane::ID() const { return GetID(); }

//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) TDataStd_Plane::NewEmpty () const
{  
  return new TDataStd_Plane(); 
}

//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================

void TDataStd_Plane::Restore(const Handle(TDF_Attribute)& With)  {}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void TDataStd_Plane::Paste (const Handle(TDF_Attribute)& Into, const Handle(TDF_RelocationTable)& RT) const { }


//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TDataStd_Plane::Dump (Standard_OStream& anOS) const
{  
  anOS << "Plane";
  return anOS;
}
