// File:	TopAbs.cxx
// Created:	Tue Apr 23 15:45:21 1991
// Author:	Remi LEQUETTE
//		<rle@topsn3>
// Modified by model, Thu Jun 25 10:40:27 1992


#include <TopAbs.ixx>

//=======================================================================
//function : TopAbs_Print
//purpose  : print the name of an Orientation on a stream
//=======================================================================

Standard_OStream& TopAbs::Print(const TopAbs_Orientation orient, 
				Standard_OStream& s)
{
  switch(orient) {
  case TopAbs_FORWARD :
    s << "FORWARD";
    break;
  case TopAbs_REVERSED :
    s << "REVERSED";
    break;
  case TopAbs_INTERNAL :
    s << "INTERNAL";
    break;
  case TopAbs_EXTERNAL :
    s << "EXTERNAL";
    break;
  }
  return s;
}

//=======================================================================
//function : TopAbs_Reverse
//purpose  : reverse an  Orientation
//=======================================================================

TopAbs_Orientation TopAbs::Reverse(const TopAbs_Orientation Ori)
{
  switch (Ori) {
  case TopAbs_FORWARD :
    return TopAbs_REVERSED;
  case TopAbs_REVERSED :
    return TopAbs_FORWARD;
  case TopAbs_INTERNAL :
    return TopAbs_INTERNAL;
  case TopAbs_EXTERNAL :
    return TopAbs_EXTERNAL;
  }
  return TopAbs_FORWARD;
}

//=======================================================================
//function : TopAbs_Complement
//purpose  : reverse an  Orientation
//=======================================================================

TopAbs_Orientation TopAbs::Complement(const TopAbs_Orientation Ori)
{
  switch (Ori) {
  case TopAbs_FORWARD :
    return TopAbs_REVERSED;
  case TopAbs_REVERSED :
    return TopAbs_FORWARD;
  case TopAbs_INTERNAL :
    return TopAbs_EXTERNAL;
  case TopAbs_EXTERNAL :
    return TopAbs_INTERNAL;
  }
  return TopAbs_FORWARD;
}

//=======================================================================
//function : TopAbs_Compose
//purpose  : Compose two orientations
//=======================================================================

TopAbs_Orientation TopAbs::Compose(const TopAbs_Orientation O1, 
				   const TopAbs_Orientation O2)
{
  // see the composition table in the file  TopAbs.cdl
  if ((O1 == TopAbs_INTERNAL) ||
      (O1 == TopAbs_EXTERNAL))       return O1;
  if  (O1 == TopAbs_FORWARD)         return O2;
  // O1 is Reversed
  else                               return TopAbs::Reverse(O2);
}


//=======================================================================
//function : TopAbs_Print
//purpose  : print the name of a ShapeEnum on a stream.
//=======================================================================

Standard_OStream& TopAbs::Print(const TopAbs_ShapeEnum se, 
				Standard_OStream& s)
{
  switch(se) {
  case TopAbs_COMPOUND :
    s << "COMPOUND";
    break;
  case TopAbs_COMPSOLID :
    s << "COMPSOLID";
    break;
  case TopAbs_SOLID :
    s << "SOLID";
    break;
  case TopAbs_SHELL :
    s << "SHELL";
    break;
  case TopAbs_FACE :
    s << "FACE";
    break;
  case TopAbs_WIRE :
    s << "WIRE";
    break;
  case TopAbs_EDGE :
    s << "EDGE";
    break;
  case TopAbs_VERTEX :
    s << "VERTEX";
    break;
  case TopAbs_SHAPE :
    s << "SHAPE";
    break;
  }
  return s;
}


//=======================================================================
//function : TopAbs_Print
//purpose  : print the name of a State on a stream.
//=======================================================================

Standard_OStream& TopAbs::Print(const TopAbs_State st, 
				Standard_OStream& s)
{
  switch(st) {
  case TopAbs_ON :
    s << "ON";
    break;
  case TopAbs_IN :
    s << "IN";
    break;
  case TopAbs_OUT :
    s << "OUT";
    break;
  case TopAbs_UNKNOWN :
    s << "UNKNOWN";
    break;
  }
  return s;
}
