// 2DGeomDoc.cpp : implementation of the C2DGeomDoc class
//

#include "stdafx.h"

#include "2DGeomDoc.h"

#include "2DGeomApp.h"
#include <Primitive\Sample2D_Curve.h>
#include "Geom2dAPI_Interpolate.hxx"
#include <PropertiesSheet.h>

/////////////////////////////////////////////////////////////////////////////
// C2DGeomDoc

IMPLEMENT_DYNCREATE(C2DGeomDoc, CDocument)

BEGIN_MESSAGE_MAP(C2DGeomDoc, CDocument)
	//{{AFX_MSG_MAP(C2DGeomDoc)
	ON_COMMAND(ID_MENU_CASCADE_PROPERTIES, OnBUTTONTest2DProperties)
	ON_COMMAND(ID_BUTTON_Test_Curve, OnBUTTONTestCurve)
	ON_COMMAND(ID_BUTTON_Erase, OnBUTTONErase)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C2DGeomDoc construction/destruction

C2DGeomDoc::C2DGeomDoc()
{
}

C2DGeomDoc::~C2DGeomDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// C2DGeomDoc diagnostics

#ifdef _DEBUG
void C2DGeomDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void C2DGeomDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// C2DGeomDoc commands

void C2DGeomDoc::OnBUTTONTest2DProperties() 
{
// TODO: Add your command handler code here
  CPropertiesSheet aDial;
  aDial.SetViewer(my2DViewer);
  aDial.DoModal();
}

void C2DGeomDoc::OnBUTTONErase() 
{
   myAISInteractiveContext2D->EraseAll();
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Erase;
  TCollection_AsciiString Message("\
call :    \n\
   myAISInteractiveContext2D->EraseAll();");

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}


void C2DGeomDoc::OnBUTTONTestCurve() 
{
  Standard_Integer color = 1;
  Standard_Integer type = 1;
  Standard_Integer width = 1;

  for (Standard_Integer i=0;i<=5;i++) 
   for (Standard_Integer j=0;j<=5;j++)
   {
     Handle_Geom2d_Curve aNewCurve  = GCE2d_MakeSegment ( gp_Pnt2d(10*i,10*j) , 
                                                          gp_Pnt2d(10*i+5,10*j+10 )).Value() ; 
     Handle(Sample2D_Curve) aCurve   = new Sample2D_Curve(aNewCurve);

	 aCurve->SetTypeOfLineIndex(type++);
	 aCurve->SetWidthOfLineIndex(width++);
     aCurve->SetColorIndex(color++);
     
	 aCurve->SetHighlightMode(AIS2D_TOD_OBJECT);

	 myAISInteractiveContext2D->Display(aCurve,            // object
                                        Standard_False);  // Redraw

     if (type == 5) type = 1; 
     if (width == 9) width = 1;       
     if (color == 2) color = 3;  // 2 = noir !!
     if (color == 13) color = 1; // 13 = nbcolor by default
   }

  FitAll2DViews(Standard_True); // Update Viewer
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Test_Curve;
 
  TCollection_AsciiString Message(" \
create a set of Sample2D_Curve and display it:    \n\
------------------------------------------------------------------------------ \n\
  Standard_Integer color = 1;\n\
  Standard_Integer type = 1; \n\
  Standard_Integer width = 1; \n\
\n\
  for (Standard_Integer i=0;i<=5;i++) \n\
   for (Standard_Integer j=0;j<=5;j++)\n\
   {\n\
     Handle_Geom2d_Curve aNewCurve  = GCE2d_MakeSegment ( gp_Pnt2d(10*i,10*j) , \n\
                                                          gp_Pnt2d(10*i+5,10*j+10 )).Value() ; \n\
     Handle(Sample2D_Curve) aCurve   = new Sample2D_Curve(aNewCurve);\n\
     aCurve->SetColorIndex(color++);\n\
     aCurve->SetTypeOfLineIndex(type++);\n\
     aCurve->SetWidthOfLineIndex(width++);\n\
     aCurve->SetHighlightMode(AIS2D_TOD_OBJECT); \n\
 \n\
     myAISInteractiveContext2D->Display(aCurve,            // object\n\
                                        Standard_False);   // Redraw\n\
     if (type == 5) type = 1; //Max number of types + 1\n\
     if (width == 9) width = 1;  \n\
     if (color == 2) color =3;  // 2 = noir !!\n\
     if (color == 13) color =1; // 13 = nbcolor by default\n\
   }\n\
------------------------------------------------------------------------------ \n\
   after that the system call the SetContext Methods :                    \n\
------------------------------------------------------------------------------ \n");
Message += "\
void Sample2D_Curve::Compute(const Handle(AIS2D_InteractiveContext)& theContext) \n\
{\n\
  AIS2D_InteractiveObject::SetContext(theContext); \n\
\n\
  Handle(Prs2d_AspectLine) aLineAspect = new Prs2d_AspectLine;  \n\
  aLineAspect->SetTypeOfFill(Graphic2d_TOPF_FILLED); \n\
\n\
  \n\
  Handle(Graphic2d_SetOfCurves) segment;\n\
  segment = new Graphic2d_SetOfCurves(this);\n\
\n\
  segment->Add(myGeom2dCurve);\n\
  \n\
\n\
  segment->SetColorIndex (myColorIndex);\n\
  segment->SetWidthIndex (myWidthOfLineIndex );\n\
  segment->SetTypeIndex  (myTypeOfLineIndex  );\n\
  \n\
  SetAspect(aLineAspect); \n\
}\n\
\n";

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}



