#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_BootConformsToProfile.mof
	cimmof -aE -n $4 $6/mof/OpenDRIM_BootConformsToProfile.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_BootConformsToProfile provider module";
Name = "Boot_OpenDRIM_BootConformsToProfileModule";
Location = "cmpiBoot_OpenDRIM_BootConformsToProfileProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_BootConformsToProfile provider";
Name = "Boot_OpenDRIM_BootConformsToProfileProvider";
ProviderModuleName = "Boot_OpenDRIM_BootConformsToProfileModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_BootConformsToProfile provider capabilities";
ProviderModuleName = "Boot_OpenDRIM_BootConformsToProfileModule";
ProviderName = "Boot_OpenDRIM_BootConformsToProfileProvider";
ClassName = "OpenDRIM_BootConformsToProfile";
ProviderType = {2, 3};
Namespaces = {"$1", "$4"};
SupportedProperties = {"ConformantStandard", "ManagedElement"};
CapabilityID = "Boot_OpenDRIM_BootConformsToProfile";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_BootConformsToProfile.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_BootConformsToProfile]   
   provider: Boot_OpenDRIM_BootConformsToProfileProvider
   location: cmpiBoot_OpenDRIM_BootConformsToProfileProvider
   type: instance association
   namespace: $1 $4
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_BootConformsToProfile.mof
	sfcbstage -r $OUTFILE -n $4 $6/mof/OpenDRIM_BootConformsToProfile.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_BootConformsToProfile-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_BootConformsToProfile.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	owmofc -u http://localhost/$4 $OUTFILE
	
	rm -f $OUTFILE
	
fi
