/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_OPERATINGSYSTEMSTATISTICSACCESS_H_
#define OPENDRIM_OPERATINGSYSTEMSTATISTICSACCESS_H_

#include "OS_Common.h"

#include "OpenDRIM_OperatingSystemStatistics.h"
#include "assocOpenDRIM_OperatingSystemStatistics.h"

int OS_OpenDRIM_OperatingSystemStatistics_load(const CMPIBroker* broker, string& errorMessage);

int OS_OpenDRIM_OperatingSystemStatistics_unload(string& errorMessage);

int OS_OpenDRIM_OperatingSystemStatistics_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OperatingSystemStatistics>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OperatingSystemStatistics_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OperatingSystemStatistics& instance, const char** properties, string& errorMessage);

int OS_OpenDRIM_OperatingSystemStatistics_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemStatistics& newInstance, const OpenDRIM_OperatingSystemStatistics& oldInstance, const char** properties, string& errorMessage);

int OS_OpenDRIM_OperatingSystemStatistics_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemStatistics& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystemStatistics_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemStatistics& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystemStatistics_associatorElementToStats(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Element_instance, const char** properties, vector<Instance>& Stats_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OperatingSystemStatistics_associatorStatsToElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Stats_instance, const char** properties, vector<Instance>& Element_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OperatingSystemStatistics_referenceElementToStats(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Element_instance, const vector<Instance>& Stats_instances, vector<OpenDRIM_OperatingSystemStatistics>& OpenDRIM_OperatingSystemStatistics_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OperatingSystemStatistics_referenceStatsToElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Stats_instance, const vector<Instance>& Element_instances, vector<OpenDRIM_OperatingSystemStatistics>& OpenDRIM_OperatingSystemStatistics_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OperatingSystemStatistics_populate(OpenDRIM_OperatingSystemStatistics& instance, string& errorMessage);

#endif /*OPENDRIM_OPERATINGSYSTEMSTATISTICSACCESS_H_*/
