/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_LOGMANAGESRECORD_H_
#define OPENDRIM_LOGMANAGESRECORD_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_RecordForLog.h"
#include "CIM_RecordForLogAccess.h"
#include "cmpiCIM_Log.h"
#include "CIM_LogAccess.h"
*/

const static char* OpenDRIM_LogManagesRecord_classnames[] = {"OpenDRIM_LogManagesRecord"}; // CIM_LogManagesRecord
static string OpenDRIM_LogManagesRecord_NAMESPACE = _NAMESPACE;
const static string Record_role = "Record";
const static char* Record_classnames[] = {"OpenDRIM_LogEntry"}; // CIM_LogEntry
const static string Record_NAMESPACE = _NAMESPACE;

const static string Log_role = "Log";
const static char* Log_classnames[] = {"OpenDRIM_RecordLog"}; // CIM_RecordLog
const static string Log_NAMESPACE = _NAMESPACE;

class OpenDRIM_LogManagesRecord {

public:
	
	Objectpath Log;
	bool Log_isNULL;
	
	Objectpath Record;
	bool Record_isNULL;
	
	OpenDRIM_LogManagesRecord() {
		Log_isNULL = true;
		Record_isNULL = true;
	}
	
	~OpenDRIM_LogManagesRecord() {}
	
	string getKeys() const {
		return CF_toLowCase(".Log=\"" + CF_quoteString(Log.toString()) + "\""".Record=\"" + CF_quoteString(Record.toString()) + "\"");
	}

	int getLog(Objectpath& value) const {
		if (Log_isNULL==true)
			return NOT_FOUND;
		value = Log;
		return OK;
	}
	
	int setLog(const Objectpath& newValue) {
		Log = newValue;
		Log.setNamespace(Log_NAMESPACE);
		Log_isNULL = false;
		return OK;
	}

	int getRecord(Objectpath& value) const {
		if (Record_isNULL==true)
			return NOT_FOUND;
		value = Record;
		return OK;
	}
	
	int setRecord(const Objectpath& newValue) {
		Record = newValue;
		Record.setNamespace(Record_NAMESPACE);
		Record_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_LOGMANAGESRECORD_H_*/
