/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __FIXPOLY_H__
#define __FIXPOLY_H__

#define MAX_POLY_SPLITS 64
#define MAX_POLY_POINTS 100

struct SplitPoint
{
    float x;
    float y;
};

struct SplitPoly
{
  SplitPoint point[MAX_POLY_POINTS];
  int points;
};

struct SplitPolys
{
  SplitPoly poly[MAX_POLY_SPLITS];
  int polys;
};

extern void FixPoly(SplitPolys &polys);

#endif
