/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------
#ifndef GroupFileH
#define GroupFileH
//---------------------------------------------------------------------------

#include <stdio.h>
#include <string>
#include <vector>
#include <map>

using namespace std;

class GroupFile
{
  public:
    GroupFile() {}
    ~GroupFile();
    bool Open(char *fname);         
    int NumFiles();                 
    void FileList(char *list);      
    int FileSize(char *name);       
    bool LoadFile(char *name, char *buf);
    bool LoadFileB(char *name, char *buf, int start, int len);

  private:
    void _Cleanup();
    string _strtolower(char *str);

    struct _File
    {
      int size;
      int offset;
    };

    struct _GFile
    {
      int files;
      map<string, _File> file;
      FILE *fp;
    };

    vector<_GFile> _files;
};

#endif
