/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#ifndef anmH
#define anmH

#include "GroupFile.h"
#include "Render.h"

struct lpfileheader
{
 unsigned long id; // 4 character ID == "LPF "
 unsigned short maxLps;	// max # largePages allowed. 256 FOR NOW.
 unsigned short nLps; // # largePages in this file.
 unsigned long nRecords; // # records in this file.  65534 is current limit plus
			             // one for last-to-first delta for looping the animation
 unsigned short maxRecsPerLp; // # records permitted in an lp. 256 FOR NOW.   */
 unsigned short lpfTableOffset;	// Absolute Seek position of lpfTable.  1280 FOR NOW.
                    			// The lpf Table is an array of 256 large page structures
                    			// that is used to facilitate finding records in an anim
                    			// file without having to seek through all of the Large
                     			// Pages to find which one a specific record lives in.
 unsigned long contentType;	// 4 character ID == "ANIM"
 unsigned short width; // Width of screen in pixels.
 unsigned short height;	// Height of screen in pixels.
 unsigned char variant;	// 0==ANIM.
 unsigned char version;	// 0==frame rate is multiple of 18 cycles/sec.
 			            // 1==frame rate is multiple of 70 cycles/sec.
 unsigned char hasLastDelta; // 1==Last record is a delta from last-to-first frame.
 unsigned char lastDeltaValid;	// 0==The last-to-first delta (if present) hasn't been
                                // updated to match the current first&last frames,	so it
                                // should be ignored.
 unsigned char pixelType; // 0==256 color.
 unsigned char CompressionType;	// 1==(RunSkipDump) Only one used FOR NOW.
 unsigned char otherRecsPerFrm;	// 0 FOR NOW.
 unsigned char bitmaptype; // 1==320x200, 256-color.  Only one implemented so far.
 unsigned char recordTypes[32]; // Not yet implemented.
 unsigned long nFrames; // In case future version adds other records at end of
            			// file, we still know how many actual frames.
 			            // NOTE: DOES include last-to-first delta when present.
 unsigned short framesPerSecond; // Number of frames to play per second.
 unsigned short pad2[29]; // 58 bytes of filler to round up to 128 bytes total.
};

struct lp_descriptor
{
 unsigned short baseRecord;	// Number of first record in this large page.
 unsigned short nRecords; // Number of records in lp.
					      // bit 15 of "nRecords" == "has continuation from previous lp".
   	 				      // bit 14 of "nRecords" == "final record continues on next lp".
 unsigned short nBytes;	// Total number of bytes of contents, excluding header.
};

class ANMFile
{
    Texture *tex;
    Art *art;
    unsigned short pal[256];
#ifdef PLATFORM_UNIX
    char *file;
#else
    unsigned char *file;
#endif
    lpfileheader lpheader; // file header will be loaded into this structure
    lp_descriptor LpArray[256]; // array of large page structs used to find frames
#ifdef PLATFORM_UNIX
    char *thepage;
#else
    unsigned char *thepage; // pointer to the buffer where current large page is loaded
#endif
	unsigned short framecount;
    lp_descriptor curlp; // header of large page currently in memory
#ifdef PLATFORM_UNIX
    short curlpnum;
#else
    unsigned short curlpnum;
#endif
    unsigned char *screen;
    unsigned char *screen2;

    int findpage(int framenumber);
    void drawframe(int framenumber,int updateTexture);
    void loadpage(int pagenumber);
    void renderframe(int framenumber,unsigned short *page,int updateTexture);
    void CPlayRunSkipDump(unsigned char *src,unsigned char *dest);
public:
    ANMFile(GroupFile *group,char *name,Art *art);
    ~ANMFile();
    int NextFrame();
    int Seek(int frameNum);
    Texture* GetTexture() { return tex; }
    int FrameNum() { return framecount; }
    unsigned short *GetPalette() { return pal; }
    void RecreateTexture();
    void FreeTextureMem();
};
//---------------------------------------------------------------------------
#endif
