/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#ifndef artH
#define artH

#define MAX_TILES 32768
#define MAX_TILE_FILES 64
#define MAX_PAL 16

#include "GroupFile.h"
#include "Render.h"
//---------------------------------------------------------------------------

class Art
{
    long anim[MAX_TILES];
    GroupFile *fileGroup[MAX_TILE_FILES];
    char *fileNames[MAX_TILE_FILES];
    int fileCount;
    int fileNum[MAX_TILES];
    int fileOfs[MAX_TILES];
    unsigned short pal[MAX_PAL][256];
    int palUsed[MAX_PAL];
public:
    unsigned char *data[MAX_TILES];
    short sizeX[MAX_TILES];
    short sizeY[MAX_TILES];
    short origSizeX[MAX_TILES];
    short origSizeY[MAX_TILES];
    Texture *tex[MAX_PAL][MAX_TILES];
    unsigned char palR[MAX_PAL][256];
    unsigned char palG[MAX_PAL][256];
    unsigned char palB[MAX_PAL][256];
    Art();
    ~Art();
    void LoadPalette(int i,GroupFile *group,char *name);
    void LoadPalette(int i,unsigned char *palData);
    void FreePalette(int i);
    int FindFreePalette();
    void Import(GroupFile *group,char *name);
    void ImportAll(GroupFile *group);
    void RequestTexture(int n,int pal,int type=TEXTYPE_REPEAT);
    void RequestTextureData(int n);
    void ReloadTextures();
    void RecreateTextures();
    void FreeTextureMem();
    void ReloadPalettes();
    int GetTextureCount();
    int GetTextureCount(int pal);
    int GetMaxTextureID();
};

#endif
