/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------
#ifndef PLATFORM_UNIX
#include <vcl.h>
#pragma hdrstop
#else
#include "SDL_mixer.h"
#include "linux_inc.h"
#endif

#include "music.h"
#include "console.h"

static int musicStarted=0;
static int musicMute=0;

static int request=0;
static GroupFile *reqGroup;
static char reqName[256];
static HWND hWnd;
#ifdef PLATFORM_UNIX
static Mix_Music *music = NULL;
#endif

void RequestMusic(GroupFile *group,char *name)
{
    if (group->FileSize(name)==-1)
        throw "Music file does not exist\n";
    reqGroup=group;
    strcpy(reqName,name);
    request=1;
}

void ProcessMusicRequest(HWND _hWnd)
{
    if (!request) return;
    hWnd=_hWnd;
    request=0;
    if (musicStarted)
        StopMusic();
    char *buf=new char[reqGroup->FileSize(reqName)];
    reqGroup->LoadFile(reqName,buf);
    FILE *fp=fopen("tempmidi.~~~","wb");
    fwrite(buf,1,reqGroup->FileSize(reqName),fp);
    fclose(fp);
    cprintf("Loaded music %s\n",reqName);
    if (!musicMute)
    {
	    char strRet[256];
#ifndef PLATFORM_UNIX
    	mciSendString("open sequencer!tempmidi.~~~ alias duke",strRet,256,NULL);
	    mciSendString("play duke notify",strRet,256,hWnd);
        cprintf("Started music %s\n",reqName);
#else
	music = Mix_LoadMUS("tempmidi.~~~");
	if (music == NULL ) {
		cprintf("Error loading %s: %s\n",reqName, SDL_GetError());
	} else {
		Mix_PlayMusic(music,1);
		cprintf("Started music %s\n",reqName);
	}
#endif
    }
    musicStarted=1;
}

void StopMusic()
{
    if (!musicStarted)
        return;
    musicStarted=0;
    if (!musicMute)
    {
    	char strRet[256];
#ifndef PLATFORM_UNIX
	    mciSendString("close duke",strRet,256,NULL);
        cprintf("Music stopped\n");
#else
	    if (music != NULL)
	    {
		    Mix_HaltMusic();
		    Mix_FreeMusic(music); music = NULL;
		    cprintf ("Music stopped\n");
	    }
		    
#endif
    }
    remove("tempmidi.~~~");
}
//---------------------------------------------------------------------------

int IsMusicPlaying()
{
    return musicStarted;
}

void MusicMute(int mute)
{
    musicMute=mute;
    if (musicMute)
    {
        if (musicStarted)
        {
    	    char strRet[256];
#ifndef PLATFORM_UNIX
	        mciSendString("close duke",strRet,256,NULL);
            cprintf("Music stopped\n");
#else
	    if (music != NULL)
	    {
		    Mix_HaltMusic();
		    Mix_FreeMusic(music); music = NULL;
		    cprintf("Music stopped\n");
	    }
#endif
        }
    }
    else
    {
        if (musicStarted)
        {
    	    char strRet[256];
#ifndef PLATFORM_UNIX
    	    mciSendString("open sequencer!tempmidi.~~~ alias duke",strRet,256,NULL);
	        mciSendString("play duke notify",strRet,256,hWnd);
#else
	music = Mix_LoadMUS("tempmidi.~~~");
	if (music == NULL ) {
		cprintf("Error loading %s: %s\n",reqName, SDL_GetError());
	} else {
		Mix_PlayMusic(music,1);
		cprintf("Started music %s\n",reqName);
	}
#endif
        }
    }
}

#pragma package(smart_init)
