/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import com.sun.jna.Library;
import com.sun.jna.Native;
import drawtree.DrawtreeUserInterface;
import javax.swing.JOptionPane;
import util.TestFileNames;

public class DrawtreeInterface {
    public boolean DrawtreeRun(DrawtreeUserInterface.DrawtreeData inVals) {
        TestFileNames test = new TestFileNames();
        if (!test.FileAvailable(inVals.intree, "Intree")) {
            return false;
        }
        if (inVals.doplot) {
            String opt = test.FileAlreadyExists(inVals.plotfile, "Plotfile");
            if (opt == "q") {
                return false;
            }
            inVals.plotfileopt = opt == "a" ? "ab" : "wb";
        }
        String wherestr = "System.load";
        try {
            wherestr = "Native.loadLibrary";
            Drawtree Drawtree2 = (Drawtree)Native.loadLibrary("drawtree", Drawtree.class);
            Drawtree2.drawtree(inVals.intree, inVals.plotfile, inVals.plotfileopt, inVals.usefont, inVals.treegrows, inVals.usebranchlengths, inVals.labeldirec, inVals.labelangle, inVals.treerotation, inVals.treearc, inVals.iterationkind, inVals.iterationcount, inVals.regularizeangles, inVals.avoidlabeloverlap, inVals.branchrescale, inVals.branchscaler, inVals.relcharhgt, inVals.xmarginratio, inVals.ymarginratio, inVals.doplot, inVals.finalplottype);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            String mapedLibName = System.mapLibraryName("drawtree");
            String libpath = inVals.librarypath;
            libpath = mapedLibName.contains("jnilib") ? String.valueOf(libpath) + "/libdrawtree.dylib" : (mapedLibName.contains("dll") ? String.valueOf(libpath) + "\\drawtree.dll" : String.valueOf(libpath) + "/libtreegram.so");
            String msg = "Drawtree library not found in : ";
            msg = String.valueOf(msg) + libpath;
            msg = String.valueOf(msg) + " by ";
            msg = String.valueOf(msg) + wherestr;
            msg = String.valueOf(msg) + ". Error msg: ";
            msg = String.valueOf(msg) + e;
            System.out.println(msg);
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
            return false;
        }
    }

    public static interface Drawtree
    extends Library {
        public void drawtree(String var1, String var2, String var3, String var4, String var5, boolean var6, String var7, Double var8, Double var9, Double var10, String var11, int var12, boolean var13, boolean var14, boolean var15, Double var16, Double var17, double var18, double var20, boolean var22, String var23);
    }
}

