#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sherlock Holmes 4: Nemesis
# send your bug reports to contact@dotslashplay.it
###

script_version=20240516.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='sherlock-holmes-4-nemesis'
GAME_NAME='Sherlock Holmes: Nemesis'

ARCHIVE_BASE_0_NAME='setup_sherlock_holmes_nemesis_remastered_2.0.0.2.exe'
ARCHIVE_BASE_0_MD5='80093682c232a13d7b246c490ff67cf1'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--gog'
ARCHIVE_BASE_0_PART1_NAME='setup_sherlock_holmes_nemesis_remastered_2.0.0.2-1.bin'
ARCHIVE_BASE_0_PART1_MD5='5c50ae6b9fdf9eeb33dcdb7c26b2904e'
ARCHIVE_BASE_0_TYPE='rar'
ARCHIVE_BASE_0_SIZE='2800000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.2'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/sherlock_holmes_nemesis_remastered'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
*.dll
game.exe'
CONTENT_GAME0_BIN_PATH='support/app'
CONTENT_GAME0_BIN_FILES='
game.ini
user.ini'
CONTENT_GAME_DATA_FILES='
000
logo
data.txt
shaders.0050
splash_screen.dds'

USER_PERSISTENT_FILES='
*.ini'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Games/sherlock holmes versus arsene lupin'
## Install required PhysX libraries.
WINE_WINETRICKS_VERBS='physx'

APP_MAIN_EXE='game.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101 --language=0'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
