/****************************************************************************
** Class DialogUndoStack
**
** Created: Tue Dec 21 09:13:25 2004
**      by: The User Interface Compiler ($Id: qt/main.cpp   3.3.1   edited Nov 24 13:47 $)
**
** This class will display the undo-stack of the current DVDMenu.
** It will also group together all consecutive changes to one object
** in the tree-view, so that the user can undo the whole batch of changes 
** applied to one object at once.
**
****************************************************************************/

#ifndef DIALOGUNDOSTACK_H
#define DIALOGUNDOSTACK_H

#include <qvariant.h>
#include <qdialog.h>

#define MAX_TREE_SIZE 51

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QPushButton;
class QListView;
class QListViewItem;

class UndoBuffer;
class UndoObject;
class DVDMenu;


class DialogUndoStack : public QDialog
{
    Q_OBJECT

public:
     DialogUndoStack( UndoBuffer *, DVDMenu *, QWidget* p=0, const char* n=0, bool m=FALSE, WFlags fl=0 );
    ~DialogUndoStack();

	void buildUndoTree ();

protected slots:
    virtual void languageChange();
	virtual void slotClickedOnList(QListViewItem *, const QPoint &, int);

private:
	void appendUndoStep (UndoObject *, UndoObject *, int);

private:
	// private member varaibles.
	UndoBuffer    *m_pUndoBuffer;
	DVDMenu       *m_pDVDMenu;
	QListViewItem *m_pBaseItem;
protected:
    QPushButton* buttonHelp;
    QPushButton* buttonOk;
    QPushButton* buttonCancel;
    QListView* m_pListViewUndo;
    QGridLayout* DialogUndoStackLayout;
    QHBoxLayout* Layout1;
    QSpacerItem* Horizontal_Spacing2;
};

#endif // DIALOGUNDOSTACK_H
