/****************************************************************************
** ImagePreview class
**
** Created: Tue Feb 02 22:06:51 2004
**      by: Varol Okan using Kate
**
** This class is the encapsulation of the ImagePreview from the FileSelection
** Dialog.
** It is also used in the ImageDialog.
**
****************************************************************************/
#include <qpopupmenu.h>
#include <qlistview.h>
#include <qpainter.h>
#include <qwmatrix.h>
#include <qpixmap.h>

#include "xml_dvd.h"
#include "menupreview.h"
#include "menuobject.h"
#include "buttonobject.h"
#include "objectcollection.h"

ObjectCollection::ObjectCollection (QWidget *pParent)
	: MenuObject (pParent)
{
	m_qsObjectType = QString (OBJECT_COLLECTION);
	m_bDeleteAllObjects = true;
}

ObjectCollection::~ObjectCollection ()
{
	uint t;
	if (m_bDeleteAllObjects)	{
		for (t=0;t<m_listObjectCollection.count();t++)
			delete m_listObjectCollection[t];
	}
}

void ObjectCollection::deleteAllObjects (bool bDeleteAllObjects)
{
	m_bDeleteAllObjects = bDeleteAllObjects;
}

int ObjectCollection::getCount ()
{
	return m_listObjectCollection.count();
}

MenuObject *ObjectCollection::getObject (int iObjectNumber)
{
	if (iObjectNumber > (int)m_listObjectCollection.count())
		return NULL;
	return m_listObjectCollection[iObjectNumber];
}

void ObjectCollection::append (MenuObject *pNewObject, bool bDeleteThisObject)
{
	if (pNewObject)	{
		m_listObjectCollection.append (pNewObject);
		m_listDeleteThisObject.append (bDeleteThisObject);
	}
}

void ObjectCollection::drawContents (QPainter *pPainter)
{
	// Here we simply pass the painter to the attached objects. No magic here !!!
	uint t;
	for (t=0;t<m_listObjectCollection.count();t++)
		m_listObjectCollection[t]->drawContents(pPainter);
}

void ObjectCollection::drawContents (QPainter *pPainter, int iFrameNumber, int iTotalNumberOfFrames)
{
	// Here we simply pass the painter to the attached objects. No magic here !!!
	uint t;
	for (t=0;t<m_listObjectCollection.count();t++)
		m_listObjectCollection[t]->drawContents(pPainter, iFrameNumber, iTotalNumberOfFrames);
}

bool ObjectCollection::mouseMoveEvent (QMouseEvent *pEvent)
{
	// This will move the textObject around and around and around we go ...
	QRect theRect = rect();
	int iX, iY, iWidth, iHeight;
	iWidth  = rect().width ();
	iHeight = rect().height();
	iX = rect().x() - (m_currentMousePos.x() - pEvent->pos().x());
	iY = rect().y() - (m_currentMousePos.y() - pEvent->pos().y());
	theRect.setX(iX);
	theRect.setY(iY);
	theRect.setWidth(iWidth);
	theRect.setHeight(iHeight);

	setRect(theRect);
	m_currentMousePos = pEvent->pos();
	return false;
}

bool ObjectCollection::mousePressEvent (QMouseEvent *pEvent)
{
	m_currentMousePos = pEvent->pos();
	if (pEvent->button() == Qt::RightButton)	{
		QPoint globalPos = pEvent->globalPos();

		QPopupMenu *pStackMenu = new QPopupMenu(m_pParent);
		pStackMenu->insertItem ( tr ("To Front")  , this, SLOT(slotToFront()));
		pStackMenu->insertItem ( tr ("To Back")   , this, SLOT(slotToBack()));
		globalPos.setX (globalPos.x() - pStackMenu->sizeHint().width()); // -100);
		pStackMenu->popup(globalPos, 1);

		if (m_pContextMenu)
			delete m_pContextMenu;
		m_pContextMenu = new QPopupMenu(m_pParent);
		m_pContextMenu->insertItem ( tr ("Modify ..."), this, SLOT(slotEdit()));
		m_pContextMenu->insertItem ( tr ("Delete")    , this, SLOT(slotDelete()));
		m_pContextMenu->insertSeparator();
		m_pContextMenu->insertItem ( tr ("Add Frame") , this, SLOT(slotAddFrame()));
		m_pContextMenu->insertItem ( tr ("Add Text")  , this, SLOT(slotAddImage()));
		m_pContextMenu->insertItem ( tr ("Add Image") , this, SLOT(slotAddImage()));
		m_pContextMenu->insertItem ( tr ("Add Movie") , this, SLOT(slotAddImage()));
		m_pContextMenu->insertSeparator();
		m_pContextMenu->insertItem ( tr ("Define as Button") , this, SLOT(slotDefineAsButton()));
		m_pContextMenu->exec(pEvent->globalPos(), 4);
		
		delete pStackMenu;
		if (m_pContextMenu)
			delete m_pContextMenu;
		m_pContextMenu = NULL;
		// Here we mark that the user called a menu item thus we don't want the
		// base classes to continue with the mouse event
//		if (iReturn != -1)
			return true;
	}
	else
		m_bDrawRect = true;
	return false;
}

bool ObjectCollection::mouseReleaseEvent (QMouseEvent *)
{
	m_bDrawRect = false;
	return false;
}

bool ObjectCollection::mouseDoubleClickEvent (QMouseEvent *)
{
	return false;
}

bool ObjectCollection::readProjectFile  (QDomNode &)
{
	return false;
}

bool ObjectCollection::writeProjectFile (QDomElement &)
{
	return false;
}

void ObjectCollection::createStructure (QListViewItem *pParentItem)
{
	// Creating teh ListView structure of this Button.
	QListViewItem *pCollectionItem;
	QString qsCollection = tr("Collection of %1").arg(m_listObjectCollection.count());
	
	pCollectionItem = new QListViewItem(pParentItem, m_qsName, qsCollection);
	pCollectionItem->setExpandable (TRUE);

	uint t;
	for (t=0;t<m_listObjectCollection.count();t++)	{
		m_listObjectCollection[t]->createStructure (pCollectionItem);
	}
}
/*
bool ButtonObject::readProjectFile  (QDomNode &theNode)
{
	// Okay, here we retain the stored data from the xml file.
	QDomElement theElement = theNode.toElement();
	QDomAttr attribute;

	attribute = theElement.attributeNode ( BUTTON_OBJECT_NAME );
	if (!attribute.isNull())
		m_qsName = attribute.value();

	attribute = theElement.attributeNode ( BUTTON_OBJECT_ACTION );
	if (!attribute.isNull())
		m_qsAction = attribute.value();

	attribute = theElement.attributeNode ( BUTTON_OBJECT_UP );
	if (!attribute.isNull())
		m_qsUp = attribute.value();

	attribute = theElement.attributeNode ( BUTTON_OBJECT_DOWN );
	if (!attribute.isNull())
		m_qsDown = attribute.value();

	attribute = theElement.attributeNode ( BUTTON_OBJECT_LEFT );
	if (!attribute.isNull())
		m_qsLeft = attribute.value();

	attribute = theElement.attributeNode ( BUTTON_OBJECT_RIGHT );
	if (!attribute.isNull())
		m_qsRight = attribute.value();

	attribute = theElement.attributeNode ( BUTTON_OBJECT_SOURCE_ENTRY);
	if (!attribute.isNull())
		m_qsSourceDisplayName = attribute.value();
	// Please note that the nortmal / selected / highlighted objects are read
	// in by ButtonObject::readObjects(...);
//printf ("ButtonObject::readProjectFile <%s> \n", (const char *)m_qsSourceDisplayName);
	return true;
}

bool ButtonObject::writeProjectFile (QDomElement &theElement)
{
	uint t;
	QDomDocument xmlDoc = theElement.ownerDocument();
	QDomElement buttonNode = xmlDoc.createElement( BUTTON_OBJECT );	// <FrameObject>
	// Here we set the attributes of the <dvdauthor> tag
	if (!m_qsName.isNull())
		buttonNode.setAttribute( BUTTON_OBJECT_NAME,   m_qsName );
	if (!m_qsAction.isNull())
		buttonNode.setAttribute( BUTTON_OBJECT_ACTION, m_qsAction );
	if (!m_qsUp.isNull())
		buttonNode.setAttribute( BUTTON_OBJECT_UP,     m_qsUp );
	if (!m_qsDown.isNull())
		buttonNode.setAttribute( BUTTON_OBJECT_DOWN,   m_qsDown );
	if (!m_qsLeft.isNull())
		buttonNode.setAttribute( BUTTON_OBJECT_LEFT,   m_qsLeft );
	if (!m_qsRight.isNull())
		buttonNode.setAttribute( BUTTON_OBJECT_RIGHT,  m_qsRight );
	if (m_pSourceFileEntry)
		buttonNode.setAttribute( BUTTON_OBJECT_SOURCE_ENTRY,  m_pSourceFileEntry->qsDisplayName );
//printf ("ButtonObject::writeProjectFile <%s> - <%s> \n", (const char *)m_pSourceFileEntry->qsDisplayName, (const char *)m_qsAction );

	// And here we store the ButtonObjects children ...
	QDomElement normalNode = xmlDoc.createElement( BUTTON_OBJECT_NORMAL );
	for (t=0;t<m_listNormalState.count();t++)
		m_listNormalState[t]->writeProjectFile ( normalNode );

	QDomElement selectedNode = xmlDoc.createElement( BUTTON_OBJECT_SELECTED );
	for (t=0;t<m_listSelectedState.count();t++)
		m_listSelectedState[t]->writeProjectFile ( selectedNode );

	QDomElement highlightedNode = xmlDoc.createElement( BUTTON_OBJECT_HIGHLIGHTED );
	for (t=0;t<m_listHighlightedState.count();t++)
		m_listHighlightedState[t]->writeProjectFile ( highlightedNode );

	buttonNode.appendChild( normalNode );
	buttonNode.appendChild( selectedNode );
	buttonNode.appendChild( highlightedNode );
	
	theElement.appendChild( buttonNode );
	// And here we write the base class ...
	return MenuObject::writeProjectFile( buttonNode );
}

void ButtonObject::createStructure (QListViewItem *pParentItem)
{
	// Creating teh ListView structure of this Button.
	QListViewItem *pButtonItem;
	QListViewItem *pStateItem;

	QString qsAction;
	QStringList actionList;
	if (!m_qsAction.isEmpty())	{	// For new buttons this might be empty ...
		actionList = QStringList::split (QString (STRING_SEPARATOR), m_qsAction);
		if (actionList.count() == 1)	
			qsAction = m_qsAction;
		else	{
			qsAction = actionList[0] + QString (" ") +actionList[1] + QString (" ") +actionList[2];
			if (actionList.count() == 4)
				qsAction += QString (" ") +actionList[3];
		}
	}
	pButtonItem = new QListViewItem(pParentItem, m_qsName, qsAction);
	pButtonItem->setExpandable (TRUE);

	uint t;
	for (t=0;t<m_listHighlightedState.count();t++)	{
		pStateItem = new QListViewItem(pButtonItem, QString ("Highlighted"), QString (""));
		pStateItem->setExpandable (TRUE);
		m_listHighlightedState[t]->createStructure (pStateItem);
	}
	for (t=0;t<m_listSelectedState.count();t++)	{
		pStateItem = new QListViewItem(pButtonItem, QString ("Selected"), QString (""));
		pStateItem->setExpandable (TRUE);
		m_listSelectedState[t]->createStructure (pStateItem);
	}
	for (t=0;t<m_listNormalState.count();t++)	{
		m_listNormalState[t]->createStructure (pButtonItem);
	}
}

*/
void ObjectCollection::slotEdit()
{
	mouseDoubleClickEvent(NULL);
}

void ObjectCollection::slotDelete()
{
	emit (signalDeleteMe(this));
}

void ObjectCollection::slotAddFrame()
{

}

void ObjectCollection::slotAddText()
{

}

void ObjectCollection::slotAddImage()
{

}

void ObjectCollection::slotAddMovie()
{

}

void ObjectCollection::slotDefineAsButton()
{
	emit (signalDefineAsButton(this));
}

bool ObjectCollection::readObjects (QDomNode &theNode, MenuPreview *pPreview)
{
	QDomElement collectionElement;
	QDomNode collectionNode = theNode.firstChild();
	QDomNode childNode;
	MenuObject *pNewObject;
	childNode = collectionNode.firstChild();
	while (!childNode.isNull())	{
		pNewObject = NULL;
		collectionElement   = collectionNode.toElement();
		QString tagName = collectionElement.tagName();
		// Next we should create the new Object but if we see the
		// MenoObject tag it means it is the MenuObject vars of the button
		// itself, thus we don't want to create anything. (It would put out a warning).
		if (tagName == FRAME_OBJECT)
			pNewObject = pPreview->createFrameObject (false);
		else if (tagName == TEXT_OBJECT)
			pNewObject = pPreview->createTextObject (false);
		else if (tagName == IMAGE_OBJECT)
			pNewObject = pPreview->createImageObject (false);
		else if (tagName == MOVIE_OBJECT)
			pNewObject = pPreview->createMovieObject (false);
		else if (tagName == BUTTON_OBJECT)	{
			pNewObject = pPreview->createButtonObject (false);
			// A small special handling for the Buttons ...
			// Funky, since the above function itself calls this function here ...
			((ButtonObject *)pNewObject)->readObjects(childNode, pPreview);
		}
		else if (tagName == OBJECT_COLLECTION)	{
			pNewObject = pPreview->createObjectCollection (false);
			// A small special handling for the Buttons ...
			// Funky, since the above function itself calls this function here ...
			((ObjectCollection *)pNewObject)->readObjects(childNode, pPreview);
		}
		else
			printf ("Warning: MenuPreview::readObject -=> wrong XML Node <%s>\nContinuing ...\n",
					(const char *)tagName);

		append (pNewObject);
		childNode = childNode.nextSibling ();
	}
	return true;
}

AnimationAttribute *ObjectCollection::getSpecificAttributes (long, QString)
{
	return NULL;
}

